/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.charting;

import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class GoogleChart
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String tagId;
    final String dataName;
    final String title;
    final String keyName;
    final String valueName;
    final List<ChartValue> values;
    int width;
    int height;

    public GoogleChart(String tagId, String title, String keyName, String valueName) {
        this.tagId = tagId;
        this.dataName = StringUtils.getSHA1(title).substring(0, 8);
        this.title = title;
        this.keyName = keyName;
        this.valueName = valueName;
        this.values = new ArrayList<ChartValue>();
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void addValue(String name, int value) {
        this.values.add(new ChartValue(name, value));
    }

    public void addValue(String name, float value) {
        this.values.add(new ChartValue(name, value));
    }

    public void addValue(String name, double value) {
        this.values.add(new ChartValue(name, (float)value));
    }

    protected abstract void appendChart(StringBuilder var1);

    protected void line(StringBuilder sb, String line) {
        sb.append(line);
        sb.append('\n');
    }

    protected class ChartValue
    implements Serializable,
    Comparable<ChartValue> {
        private static final long serialVersionUID = 1L;
        final String name;
        final float value;

        ChartValue(String name, float value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public int compareTo(ChartValue o) {
            if (this.value > o.value) {
                return -1;
            }
            if (this.value < o.value) {
                return 1;
            }
            return 0;
        }
    }
}

