/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.WebPage;

public class PageRegistration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String translationKey;
    public final Class<? extends WebPage> pageClass;
    public final PageParameters params;

    public PageRegistration(String translationKey, Class<? extends WebPage> pageClass) {
        this(translationKey, pageClass, null);
    }

    public PageRegistration(String translationKey, Class<? extends WebPage> pageClass, PageParameters params) {
        this.translationKey = translationKey;
        this.pageClass = pageClass;
        this.params = params;
    }

    public static class DropDownMenuItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final PageParameters parameters;
        final String displayText;
        final String parameter;
        final String value;
        final boolean isSelected;

        public DropDownMenuItem() {
            this(null, null, null, null);
        }

        public DropDownMenuItem(String displayText, String parameter, String value) {
            this(displayText, parameter, value, null);
        }

        public DropDownMenuItem(String displayText, String parameter, String value, PageParameters params) {
            this.displayText = displayText;
            this.parameter = parameter;
            this.value = value;
            if (params == null) {
                this.parameters = new PageParameters();
                this.setParameter(parameter, value);
                this.isSelected = false;
            } else {
                this.parameters = new PageParameters((Map)params);
                if (this.parameters.containsKey((Object)parameter)) {
                    this.isSelected = params.getString(parameter).equals(value);
                    if (this.isSelected) {
                        this.parameters.remove((Object)parameter);
                    } else {
                        this.setParameter(parameter, value);
                    }
                } else {
                    this.isSelected = false;
                    this.setParameter(parameter, value);
                }
            }
        }

        private void setParameter(String parameter, String value) {
            if (!StringUtils.isEmpty(parameter)) {
                if (StringUtils.isEmpty(value)) {
                    this.parameters.remove((Object)parameter);
                } else {
                    this.parameters.put(parameter, (Object)value);
                }
            }
        }

        public String formatParameter() {
            if (StringUtils.isEmpty(this.parameter) || StringUtils.isEmpty(this.value)) {
                return "";
            }
            return this.parameter + "=" + this.value;
        }

        public PageParameters getPageParameters() {
            return this.parameters;
        }

        public boolean isDivider() {
            return this.displayText == null && this.value == null && this.parameter == null;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public int hashCode() {
            if (this.isDivider()) {
                return super.hashCode();
            }
            if (StringUtils.isEmpty(this.displayText)) {
                return this.value.hashCode() + this.parameter.hashCode();
            }
            return this.displayText.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DropDownMenuItem) {
                return this.hashCode() == o.hashCode();
            }
            return false;
        }

        public String toString() {
            if (StringUtils.isEmpty(this.displayText)) {
                return this.formatParameter();
            }
            return this.displayText;
        }
    }

    public static class DropDownMenuRegistration
    extends PageRegistration {
        private static final long serialVersionUID = 1L;
        public final List<DropDownMenuItem> menuItems = new ArrayList<DropDownMenuItem>();

        public DropDownMenuRegistration(String translationKey, Class<? extends WebPage> pageClass) {
            super(translationKey, pageClass);
        }
    }

    public static class OtherPageLink
    extends PageRegistration {
        private static final long serialVersionUID = 1L;
        public final String url;

        public OtherPageLink(String translationKey, String url) {
            super(translationKey, null);
            this.url = url;
        }
    }
}

