/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.GitBlit;
import com.gitblit.models.UserModel;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.RequiresAdminRole;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RepositoriesPage;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.strategies.page.AbstractPageAuthorizationStrategy;

public class AuthorizationStrategy
extends AbstractPageAuthorizationStrategy
implements IUnauthorizedComponentInstantiationListener {
    protected boolean isPageAuthorized(Class pageClass) {
        if (RepositoriesPage.class.equals((Object)pageClass)) {
            return true;
        }
        if (BasePage.class.isAssignableFrom(pageClass)) {
            boolean authenticateView = GitBlit.getBoolean("web.authenticateViewPages", true);
            boolean authenticateAdmin = GitBlit.getBoolean("web.authenticateAdminPages", true);
            boolean allowAdmin = GitBlit.getBoolean("web.allowAdministration", true);
            GitBlitWebSession session = GitBlitWebSession.get();
            if (authenticateView && !session.isLoggedIn()) {
                session.cacheRequest(pageClass);
                return false;
            }
            UserModel user = session.getUser();
            if (pageClass.isAnnotationPresent(RequiresAdminRole.class)) {
                if (allowAdmin) {
                    if (authenticateAdmin) {
                        if (user != null) {
                            return user.canAdmin();
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public void onUnauthorizedInstantiation(Component component) {
        if (component instanceof BasePage) {
            throw new RestartResponseException(RepositoriesPage.class);
        }
    }
}

