/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.Metric;
import com.gitblit.models.RefModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricUtils.class);

    private static void error(Throwable t, Repository repository, String pattern, Object ... objects) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (objects != null && objects.length > 0) {
            for (Object o : objects) {
                parameters.add(o);
            }
        }
        if (repository != null) {
            parameters.add(0, repository.getDirectory().getAbsolutePath());
        }
        LOGGER.error(MessageFormat.format(pattern, parameters.toArray()), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Metric> getDateMetrics(Repository repository, String objectId, boolean includeTotal, String dateFormat, TimeZone timezone) {
        Metric total = new Metric("TOTAL");
        HashMap<String, Metric> metricMap = new HashMap<String, Metric>();
        if (JGitUtils.hasCommits(repository)) {
            List<RefModel> tags = JGitUtils.getTags(repository, true, -1);
            HashMap<ObjectId, RefModel> tagMap = new HashMap<ObjectId, RefModel>();
            for (RefModel tag : tags) {
                tagMap.put(tag.getReferencedObjectId(), tag);
            }
            RevWalk revWalk = null;
            try {
                SimpleDateFormat df;
                ObjectId branchObject = StringUtils.isEmpty(objectId) ? JGitUtils.getDefaultBranch(repository) : repository.resolve(objectId);
                revWalk = new RevWalk(repository);
                RevCommit lastCommit = revWalk.parseCommit((AnyObjectId)branchObject);
                revWalk.markStart(lastCommit);
                if (StringUtils.isEmpty(dateFormat)) {
                    int diffDays;
                    RevCommit firstCommit = JGitUtils.getFirstCommit(repository, branchObject.getName());
                    total.duration = diffDays = (lastCommit.getCommitTime() - firstCommit.getCommitTime()) / 86400;
                    df = diffDays <= 365 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM");
                } else {
                    df = new SimpleDateFormat(dateFormat);
                }
                df.setTimeZone(timezone);
                RevWalk revlog = revWalk;
                for (RevCommit rev : revlog) {
                    Date d = JGitUtils.getCommitDate(rev);
                    String p = df.format(d);
                    if (!metricMap.containsKey(p)) {
                        metricMap.put(p, new Metric(p));
                    }
                    Metric m = (Metric)metricMap.get(p);
                    m.count += 1.0;
                    total.count += 1.0;
                    if (!tagMap.containsKey(rev.getId())) continue;
                    m.tag += 1.0;
                    total.tag += 1.0;
                }
            }
            catch (Throwable t) {
                MetricUtils.error(t, repository, "{0} failed to mine log history for date metrics of {1}", objectId);
            }
            finally {
                if (revWalk != null) {
                    revWalk.dispose();
                }
            }
        }
        ArrayList keys = new ArrayList(metricMap.keySet());
        Collections.sort(keys);
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (String key : keys) {
            metrics.add((Metric)metricMap.get(key));
        }
        if (includeTotal) {
            metrics.add(0, total);
        }
        return metrics;
    }

    public static List<Metric> getAuthorMetrics(Repository repository, String objectId, boolean byEmailAddress) {
        HashMap<String, Metric> metricMap = new HashMap<String, Metric>();
        if (JGitUtils.hasCommits(repository)) {
            try {
                RevWalk walk = new RevWalk(repository);
                ObjectId branchObject = StringUtils.isEmpty(objectId) ? JGitUtils.getDefaultBranch(repository) : repository.resolve(objectId);
                RevCommit lastCommit = walk.parseCommit((AnyObjectId)branchObject);
                walk.markStart(lastCommit);
                RevWalk revlog = walk;
                for (RevCommit rev : revlog) {
                    String p;
                    if (byEmailAddress) {
                        p = rev.getAuthorIdent().getEmailAddress().toLowerCase();
                        if (StringUtils.isEmpty(p)) {
                            p = rev.getAuthorIdent().getName().toLowerCase();
                        }
                    } else {
                        p = rev.getAuthorIdent().getName().toLowerCase();
                        if (StringUtils.isEmpty(p)) {
                            p = rev.getAuthorIdent().getEmailAddress().toLowerCase();
                        }
                    }
                    if (!metricMap.containsKey(p = p.replace('\n', ' ').replace('\r', ' ').trim())) {
                        metricMap.put(p, new Metric(p));
                    }
                    Metric m = (Metric)metricMap.get(p);
                    m.count += 1.0;
                }
            }
            catch (Throwable t) {
                MetricUtils.error(t, repository, "{0} failed to mine log history for author metrics of {1}", objectId);
            }
        }
        ArrayList keys = new ArrayList(metricMap.keySet());
        Collections.sort(keys);
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (String key : keys) {
            metrics.add((Metric)metricMap.get(key));
        }
        return metrics;
    }
}

