/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.LoggerFactory;
import org.tautua.markdownpapers.Markdown;
import org.tautua.markdownpapers.parser.ParseException;

public class MarkdownUtils {
    public static String transformMarkdown(String markdown) throws java.text.ParseException {
        try {
            StringReader reader = new StringReader(markdown);
            String html = MarkdownUtils.transformMarkdown(reader);
            reader.close();
            return html;
        }
        catch (IllegalArgumentException e) {
            throw new java.text.ParseException(e.getMessage(), 0);
        }
        catch (NullPointerException p) {
            throw new java.text.ParseException("Markdown string is null!", 0);
        }
    }

    public static String transformMarkdown(Reader markdownReader) throws java.text.ParseException {
        StringWriter writer = new StringWriter();
        try {
            Markdown md = new Markdown();
            md.transform(markdownReader, (Writer)writer);
            String string = writer.toString().trim();
            return string;
        }
        catch (StringIndexOutOfBoundsException e) {
            LoggerFactory.getLogger(MarkdownUtils.class).error("MarkdownPapers failed to parse Markdown!", (Throwable)e);
            throw new java.text.ParseException(e.getMessage(), 0);
        }
        catch (ParseException p) {
            LoggerFactory.getLogger(MarkdownUtils.class).error("MarkdownPapers failed to parse Markdown!", (Throwable)p);
            throw new java.text.ParseException(p.getMessage(), 0);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(MarkdownUtils.class).error("MarkdownPapers failed to parse Markdown!", (Throwable)e);
            throw new java.text.ParseException(e.getMessage(), 0);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }
}

