/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.X509Utils;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    public static String getGitblitURL(HttpServletRequest request) {
        String forwardedScheme;
        String scheme = request.getScheme();
        int port = request.getServerPort();
        String forwardedPort = request.getHeader("X-Forwarded-Port");
        if (StringUtils.isEmpty(forwardedPort)) {
            forwardedPort = request.getHeader("X_Forwarded_Port");
        }
        if (!StringUtils.isEmpty(forwardedPort)) {
            try {
                port = Integer.parseInt(forwardedPort);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty(forwardedScheme = request.getHeader("X-Forwarded-Proto"))) {
            forwardedScheme = request.getHeader("X_Forwarded_Proto");
        }
        if (!StringUtils.isEmpty(forwardedScheme) && "https".equals(scheme = forwardedScheme) && port == 80) {
            port = 443;
        }
        String context = request.getContextPath();
        String forwardedContext = request.getHeader("X-Forwarded-Context");
        if (forwardedContext != null) {
            forwardedContext = request.getHeader("X_Forwarded_Context");
        }
        if (!StringUtils.isEmpty(forwardedContext)) {
            context = forwardedContext;
        }
        if (context.length() > 0 && context.charAt(context.length() - 1) == '/') {
            context = context.substring(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(request.getServerName());
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            sb.append(":" + port);
        }
        sb.append(context);
        return sb.toString();
    }

    public static UserModel getUserModelFromCertificate(HttpServletRequest httpRequest, boolean checkValidity, String ... usernameOIDs) {
        X509Certificate[] certChain;
        if (httpRequest.getAttribute("javax.servlet.request.X509Certificate") != null && (certChain = (X509Certificate[])httpRequest.getAttribute("javax.servlet.request.X509Certificate")) != null) {
            X509Certificate cert = certChain[0];
            if (checkValidity) {
                try {
                    cert.checkValidity(new Date());
                }
                catch (CertificateNotYetValidException e) {
                    LoggerFactory.getLogger(HttpUtils.class).info(MessageFormat.format("X509 certificate {0} is not yet valid", cert.getSubjectDN().getName()));
                    return null;
                }
                catch (CertificateExpiredException e) {
                    LoggerFactory.getLogger(HttpUtils.class).info(MessageFormat.format("X509 certificate {0} has expired", cert.getSubjectDN().getName()));
                    return null;
                }
            }
            return HttpUtils.getUserModelFromCertificate(cert, usernameOIDs);
        }
        return null;
    }

    public static UserModel getUserModelFromCertificate(X509Certificate cert, String ... usernameOIDs) {
        X509Utils.X509Metadata metadata = X509Utils.getMetadata(cert);
        UserModel user = new UserModel(metadata.commonName);
        user.emailAddress = metadata.emailAddress;
        user.isAuthenticated = false;
        if (usernameOIDs == null || usernameOIDs.length == 0) {
            usernameOIDs = new String[]{"CN"};
        }
        StringBuilder an = new StringBuilder();
        for (String oid : usernameOIDs) {
            String val = metadata.getOID(oid.toUpperCase(), null);
            if (val == null) continue;
            an.append(val).append(' ');
        }
        user.username = an.toString().trim();
        return user;
    }

    public static X509Utils.X509Metadata getCertificateMetadata(HttpServletRequest httpRequest) {
        X509Certificate[] certChain;
        if (httpRequest.getAttribute("javax.servlet.request.X509Certificate") != null && (certChain = (X509Certificate[])httpRequest.getAttribute("javax.servlet.request.X509Certificate")) != null) {
            X509Certificate cert = certChain[0];
            return X509Utils.getMetadata(cert);
        }
        return null;
    }

    public static boolean isIpAddress(String address) {
        if (StringUtils.isEmpty(address)) {
            return false;
        }
        String[] fields = address.split("\\.");
        if (fields.length == 4) {
            for (String field : fields) {
                try {
                    int value = Integer.parseInt(field);
                    if (value >= 0 && value <= 255) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

