/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.GitWebDiffFormatter;
import com.gitblit.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawParseUtils;

public class GitBlitDiffFormatter
extends GitWebDiffFormatter {
    private final OutputStream os;
    private int left;
    private int right;

    public GitBlitDiffFormatter(OutputStream os) {
        super(os);
        this.os = os;
    }

    @Override
    protected void writeHunkHeader(int aStartLine, int aEndLine, int bStartLine, int bEndLine) throws IOException {
        this.os.write("<tr><th>..</th><th>..</th><td class='hunk_header'>".getBytes());
        this.os.write(64);
        this.os.write(64);
        this.writeRange('-', aStartLine + 1, aEndLine - aStartLine);
        this.writeRange('+', bStartLine + 1, bEndLine - bStartLine);
        this.os.write(32);
        this.os.write(64);
        this.os.write(64);
        this.os.write("</td></tr>\n".getBytes());
        this.left = aStartLine + 1;
        this.right = bStartLine + 1;
    }

    @Override
    protected void writeLine(char prefix, RawText text, int cur) throws IOException {
        this.os.write("<tr>".getBytes());
        switch (prefix) {
            case '+': {
                this.os.write(("<th></th><th>" + this.right++ + "</th>").getBytes());
                this.os.write("<td><div class=\"diff add2\">".getBytes());
                break;
            }
            case '-': {
                this.os.write(("<th>" + this.left++ + "</th><th></th>").getBytes());
                this.os.write("<td><div class=\"diff remove2\">".getBytes());
                break;
            }
            default: {
                this.os.write(("<th>" + this.left++ + "</th><th>" + this.right++ + "</th>").getBytes());
                this.os.write("<td>".getBytes());
            }
        }
        this.os.write(prefix);
        String line = text.getString(cur);
        line = StringUtils.escapeForHtml(line, false);
        this.os.write(Constants.encode((String)line));
        switch (prefix) {
            case '+': 
            case '-': {
                this.os.write("</div>".getBytes());
                break;
            }
            default: {
                this.os.write("</td>".getBytes());
            }
        }
        this.os.write("</tr>\n".getBytes());
    }

    @Override
    public String getHtml() {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)this.os;
        String html = RawParseUtils.decode((byte[])bos.toByteArray());
        String[] lines = html.split("\n");
        StringBuilder sb = new StringBuilder();
        boolean inFile = false;
        String oldnull = "a/dev/null";
        for (String line : lines) {
            if (line.startsWith("index") || line.startsWith("new file") || line.startsWith("\\ No newline") || line.startsWith("---") || line.startsWith("+++")) continue;
            if (line.startsWith("diff")) {
                if ((line = StringUtils.convertOctal(line)).indexOf(oldnull) > -1) {
                    line = line.substring(("diff --git " + oldnull).length()).trim();
                    line = line.substring(2).trim();
                } else {
                    line = line.substring((line = line.substring("diff --git ".length()).trim()).startsWith("\"a/") ? 3 : 2);
                    line = line.substring(0, line.indexOf(" b/") > -1 ? line.indexOf(" b/") : line.indexOf("\"b/")).trim();
                }
                if (line.charAt(0) == '\"') {
                    line = line.substring(1);
                }
                if (line.charAt(line.length() - 1) == '\"') {
                    line = line.substring(0, line.length() - 1);
                }
                if (inFile) {
                    sb.append("</tbody></table></div>\n");
                    inFile = false;
                }
                sb.append("<div class='header'>").append(line).append("</div>");
                sb.append("<div class=\"diff\">");
                sb.append("<table><tbody>");
                inFile = true;
                continue;
            }
            sb.append(line);
        }
        sb.append("</table></div>");
        return sb.toString();
    }
}

