/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.models.FederationModel;
import com.gitblit.models.FederationProposal;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.JsonUtils;
import com.gitblit.utils.StringUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationUtils {
    private static final Type REPOSITORIES_TYPE = new TypeToken<Map<String, RepositoryModel>>(){}.getType();
    private static final Type SETTINGS_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type USERS_TYPE = new TypeToken<Collection<UserModel>>(){}.getType();
    private static final Type TEAMS_TYPE = new TypeToken<Collection<TeamModel>>(){}.getType();
    private static final Logger LOGGER = LoggerFactory.getLogger(FederationUtils.class);

    public static String asLink(String sourceURL, String token, Constants.FederationRequest req) {
        return FederationUtils.asLink(sourceURL, null, token, req, null);
    }

    public static String asLink(String remoteURL, Constants.FederationToken tokenType, String token, Constants.FederationRequest req, String myURL) {
        if (remoteURL.length() > 0 && remoteURL.charAt(remoteURL.length() - 1) == '/') {
            remoteURL = remoteURL.substring(0, remoteURL.length() - 1);
        }
        if (req == null) {
            req = Constants.FederationRequest.PULL_REPOSITORIES;
        }
        return remoteURL + "/federation/" + "?req=" + req.name().toLowerCase() + (token == null ? "" : "&token=" + token) + (tokenType == null ? "" : "&tokenType=" + tokenType.name().toLowerCase()) + (myURL == null ? "" : "&url=" + StringUtils.encodeURL(myURL));
    }

    public static List<FederationModel> getFederationRegistrations(IStoredSettings settings) {
        ArrayList<FederationModel> federationRegistrations = new ArrayList<FederationModel>();
        List<String> keys = settings.getAllKeys("federation");
        keys.remove("federation.name");
        keys.remove("federation.passphrase");
        keys.remove("federation.allowProposals");
        keys.remove("federation.proposalsFolder");
        keys.remove("federation.defaultFrequency");
        keys.remove("federation.sets");
        Collections.sort(keys);
        HashMap<String, FederationModel> federatedModels = new HashMap<String, FederationModel>();
        for (String key : keys) {
            String setting;
            String value = key.substring("federation".length() + 1);
            List<String> values = StringUtils.getStringsFromValue(value, "\\.");
            String server2 = values.get(0);
            if (!federatedModels.containsKey(server2)) {
                federatedModels.put(server2, new FederationModel(server2));
            }
            if ((setting = values.get(1)).equals("url")) {
                ((FederationModel)federatedModels.get((Object)server2)).url = settings.getString(key, "");
                continue;
            }
            if (setting.equals("token")) {
                ((FederationModel)federatedModels.get((Object)server2)).token = settings.getString(key, "");
                continue;
            }
            if (setting.equals("frequency")) {
                ((FederationModel)federatedModels.get((Object)server2)).frequency = settings.getString(key, "");
                continue;
            }
            if (setting.equals("folder")) {
                ((FederationModel)federatedModels.get((Object)server2)).folder = settings.getString(key, "");
                continue;
            }
            if (setting.equals("bare")) {
                ((FederationModel)federatedModels.get((Object)server2)).bare = settings.getBoolean(key, true);
                continue;
            }
            if (setting.equals("mirror")) {
                ((FederationModel)federatedModels.get((Object)server2)).mirror = settings.getBoolean(key, true);
                continue;
            }
            if (setting.equals("mergeAccounts")) {
                ((FederationModel)federatedModels.get((Object)server2)).mergeAccounts = settings.getBoolean(key, false);
                continue;
            }
            if (setting.equals("sendStatus")) {
                ((FederationModel)federatedModels.get((Object)server2)).sendStatus = settings.getBoolean(key, false);
                continue;
            }
            if (setting.equals("notifyOnError")) {
                ((FederationModel)federatedModels.get((Object)server2)).notifyOnError = settings.getBoolean(key, false);
                continue;
            }
            if (setting.equals("exclude")) {
                ((FederationModel)federatedModels.get((Object)server2)).exclusions = settings.getStrings(key);
                continue;
            }
            if (!setting.equals("include")) continue;
            ((FederationModel)federatedModels.get((Object)server2)).inclusions = settings.getStrings(key);
        }
        for (FederationModel model : federatedModels.values()) {
            if (StringUtils.isEmpty(model.url)) {
                LOGGER.warn(MessageFormat.format("Dropping federation registration {0}. Missing url.", model.name));
                continue;
            }
            if (StringUtils.isEmpty(model.token)) {
                LOGGER.warn(MessageFormat.format("Dropping federation registration {0}. Missing token.", model.name));
                continue;
            }
            if (StringUtils.isEmpty(model.frequency)) {
                model.frequency = settings.getString("federation.defaultFrequency", "60 mins");
            }
            federationRegistrations.add(model);
        }
        return federationRegistrations;
    }

    public static boolean poke(String remoteUrl) throws Exception {
        String json;
        String url = FederationUtils.asLink(remoteUrl, null, Constants.FederationRequest.POKE);
        int status = JsonUtils.sendJsonString(url, json = JsonUtils.toJsonString("POKE"));
        return status == 200;
    }

    public static Constants.FederationProposalResult propose(String remoteUrl, FederationProposal proposal) throws Exception {
        String url = FederationUtils.asLink(remoteUrl, null, Constants.FederationRequest.PROPOSAL);
        String json = JsonUtils.toJsonString(proposal);
        int status = JsonUtils.sendJsonString(url, json);
        switch (status) {
            case 403: {
                return Constants.FederationProposalResult.FEDERATION_DISABLED;
            }
            case 400: {
                return Constants.FederationProposalResult.MISSING_DATA;
            }
            case 405: {
                return Constants.FederationProposalResult.NO_PROPOSALS;
            }
            case 406: {
                return Constants.FederationProposalResult.NO_POKE;
            }
            case 200: {
                return Constants.FederationProposalResult.ACCEPTED;
            }
        }
        return Constants.FederationProposalResult.ERROR;
    }

    public static Map<String, RepositoryModel> getRepositories(FederationModel registration, boolean checkExclusions) throws Exception {
        String url = FederationUtils.asLink(registration.url, registration.token, Constants.FederationRequest.PULL_REPOSITORIES);
        Map models = (Map)JsonUtils.retrieveJson(url, REPOSITORIES_TYPE);
        if (checkExclusions) {
            HashMap<String, RepositoryModel> includedModels = new HashMap<String, RepositoryModel>();
            for (Map.Entry entry : models.entrySet()) {
                if (!registration.isIncluded((RepositoryModel)entry.getValue())) continue;
                includedModels.put((String)entry.getKey(), (RepositoryModel)entry.getValue());
            }
            return includedModels;
        }
        return models;
    }

    public static List<UserModel> getUsers(FederationModel registration) throws Exception {
        String url = FederationUtils.asLink(registration.url, registration.token, Constants.FederationRequest.PULL_USERS);
        Collection models = (Collection)JsonUtils.retrieveJson(url, USERS_TYPE);
        ArrayList<UserModel> list = new ArrayList<UserModel>(models);
        return list;
    }

    public static List<TeamModel> getTeams(FederationModel registration) throws Exception {
        String url = FederationUtils.asLink(registration.url, registration.token, Constants.FederationRequest.PULL_TEAMS);
        Collection models = (Collection)JsonUtils.retrieveJson(url, TEAMS_TYPE);
        ArrayList<TeamModel> list = new ArrayList<TeamModel>(models);
        return list;
    }

    public static Map<String, String> getSettings(FederationModel registration) throws Exception {
        String url = FederationUtils.asLink(registration.url, registration.token, Constants.FederationRequest.PULL_SETTINGS);
        Map settings = (Map)JsonUtils.retrieveJson(url, SETTINGS_TYPE);
        return settings;
    }

    public static Map<String, String> getScripts(FederationModel registration) throws Exception {
        String url = FederationUtils.asLink(registration.url, registration.token, Constants.FederationRequest.PULL_SCRIPTS);
        Map scripts = (Map)JsonUtils.retrieveJson(url, SETTINGS_TYPE);
        return scripts;
    }

    public static boolean acknowledgeStatus(String identification, FederationModel registration) throws Exception {
        String json;
        String url = FederationUtils.asLink(registration.url, null, registration.token, Constants.FederationRequest.STATUS, identification);
        int status = JsonUtils.sendJsonString(url, json = JsonUtils.toJsonString(registration));
        return status == 200;
    }
}

