/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.AnnotatedLine;
import com.gitblit.utils.GitBlitDiffFormatter;
import com.gitblit.utils.GitWebDiffFormatter;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.PatchFormatter;
import com.gitblit.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiffUtils.class);

    public static String getCommitDiff(Repository repository, RevCommit commit, DiffOutputType outputType) {
        return DiffUtils.getDiff(repository, null, commit, null, outputType);
    }

    public static String getDiff(Repository repository, RevCommit commit, String path, DiffOutputType outputType) {
        return DiffUtils.getDiff(repository, null, commit, path, outputType);
    }

    public static String getDiff(Repository repository, RevCommit baseCommit, RevCommit commit, DiffOutputType outputType) {
        return DiffUtils.getDiff(repository, baseCommit, commit, null, outputType);
    }

    public static String getDiff(Repository repository, RevCommit baseCommit, RevCommit commit, String path, DiffOutputType outputType) {
        String diff = null;
        try {
            RevTree baseTree;
            GitWebDiffFormatter df;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            RawTextComparator cmp = RawTextComparator.DEFAULT;
            switch (outputType) {
                case GITWEB: {
                    df = new GitWebDiffFormatter(os);
                    break;
                }
                case GITBLIT: {
                    df = new GitBlitDiffFormatter(os);
                    break;
                }
                default: {
                    df = new DiffFormatter((OutputStream)os);
                }
            }
            df.setRepository(repository);
            df.setDiffComparator(cmp);
            df.setDetectRenames(true);
            RevTree commitTree = commit.getTree();
            if (baseCommit == null) {
                if (commit.getParentCount() > 0) {
                    RevWalk rw = new RevWalk(repository);
                    RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                    rw.dispose();
                    baseTree = parent.getTree();
                } else {
                    baseTree = commitTree;
                }
            } else {
                baseTree = baseCommit.getTree();
            }
            List diffEntries = df.scan(baseTree, commitTree);
            if (path != null && path.length() > 0) {
                for (DiffEntry diffEntry : diffEntries) {
                    if (!diffEntry.getNewPath().equalsIgnoreCase(path)) continue;
                    df.format(diffEntry);
                    break;
                }
            } else {
                df.format(diffEntries);
            }
            diff = df instanceof GitWebDiffFormatter ? df.getHtml() : os.toString();
            df.flush();
        }
        catch (Throwable t) {
            LOGGER.error("failed to generate commit diff!", t);
        }
        return diff;
    }

    public static String getCommitPatch(Repository repository, RevCommit baseCommit, RevCommit commit, String path) {
        String diff = null;
        try {
            RevTree baseTree;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            RawTextComparator cmp = RawTextComparator.DEFAULT;
            PatchFormatter df = new PatchFormatter(os);
            df.setRepository(repository);
            df.setDiffComparator(cmp);
            df.setDetectRenames(true);
            RevTree commitTree = commit.getTree();
            if (baseCommit == null) {
                if (commit.getParentCount() > 0) {
                    RevWalk rw = new RevWalk(repository);
                    RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                    baseTree = parent.getTree();
                } else {
                    baseTree = commitTree;
                }
            } else {
                baseTree = baseCommit.getTree();
            }
            List diffEntries = df.scan(baseTree, commitTree);
            if (path != null && path.length() > 0) {
                for (DiffEntry diffEntry : diffEntries) {
                    if (!diffEntry.getNewPath().equalsIgnoreCase(path)) continue;
                    df.format(diffEntry);
                    break;
                }
            } else {
                df.format(diffEntries);
            }
            diff = df.getPatch(commit);
            df.flush();
        }
        catch (Throwable t) {
            LOGGER.error("failed to generate commit diff!", t);
        }
        return diff;
    }

    public static List<AnnotatedLine> blame(Repository repository, String blobPath, String objectId) {
        ArrayList<AnnotatedLine> lines = new ArrayList<AnnotatedLine>();
        try {
            ObjectId object = StringUtils.isEmpty(objectId) ? JGitUtils.getDefaultBranch(repository) : repository.resolve(objectId);
            BlameCommand blameCommand = new BlameCommand(repository);
            blameCommand.setFilePath(blobPath);
            blameCommand.setStartCommit((AnyObjectId)object);
            BlameResult blameResult = blameCommand.call();
            RawText rawText = blameResult.getResultContents();
            int length = rawText.size();
            for (int i = 0; i < length; ++i) {
                RevCommit commit = blameResult.getSourceCommit(i);
                AnnotatedLine line = new AnnotatedLine(commit, i + 1, rawText.getString(i));
                lines.add(line);
            }
        }
        catch (Throwable t) {
            LOGGER.error("failed to generate blame!", t);
        }
        return lines;
    }

    public static enum DiffOutputType {
        PLAIN,
        GITWEB,
        GITBLIT;


        public static DiffOutputType forName(String name) {
            for (DiffOutputType type : DiffOutputType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }
}

