/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.GitBlit;
import java.io.CharConversionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(ContainerUtils.class);

    public static class CVE_2007_0450 {
        public static void test() {
            if (GitBlit.getBoolean("web.mountParameters", true) && (GitBlit.getChar("web.forwardSlashCharacter", '/') == '/' || GitBlit.getChar("web.forwardSlashCharacter", '/') == '\\')) {
                try {
                    if (!GitBlit.isGO() && !CVE_2007_0450.logCVE_2007_0450Tomcat()) {
                        LOGGER.info("Unknown container, cannot check for CVE-2007-0450 aplicability");
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Failure in checking for CVE-2007-0450 aplicability", t);
                }
            }
        }

        private static boolean logCVE_2007_0450Tomcat() {
            try {
                byte[] test = "http://server.domain:8080/context/servlet/param%2fparam".getBytes();
                Class<?> cByteChunk = Class.forName("org.apache.tomcat.util.buf.ByteChunk");
                Object mb = cByteChunk.newInstance();
                Method mByteChunck_setBytes = cByteChunk.getMethod("setBytes", byte[].class, Integer.TYPE, Integer.TYPE);
                mByteChunck_setBytes.invoke(mb, test, 0, test.length);
                Class<?> cUDecoder = Class.forName("org.apache.tomcat.util.buf.UDecoder");
                Object ud = cUDecoder.newInstance();
                Method mUDecoder_convert = cUDecoder.getMethod("convert", cByteChunk, Boolean.TYPE);
                try {
                    mUDecoder_convert.invoke(ud, mb, false);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != null && e.getTargetException() instanceof CharConversionException) {
                        LOGGER.warn("You are using a Tomcat-based server and your current settings will prevent grouped repositories, forks, personal repositories, and tree navigation from working properly. Please review the FAQ for details about running Gitblit on Tomcat. http://gitblit.com/faq.html and http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0450");
                        return true;
                    }
                    throw e;
                }
            }
            catch (Throwable t) {
                if (t instanceof ClassNotFoundException || t instanceof NoSuchMethodException || t instanceof IllegalArgumentException) {
                    return false;
                }
                LOGGER.debug("This is a tomcat, but the test operation failed somehow", t);
            }
            return true;
        }
    }
}

