/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.GitBlit;
import com.gitblit.models.Activity;
import com.gitblit.models.GravatarProfile;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.JsonUtils;
import com.gitblit.utils.StringUtils;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class ActivityUtils {
    public static List<Activity> getRecentActivity(List<RepositoryModel> models, int daysBack, String objectId, TimeZone timezone) {
        Date thresholdDate = new Date(System.currentTimeMillis() - (long)daysBack * 86400000L);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setTimeZone(timezone);
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timezone);
        HashMap<String, Activity> activity = new HashMap<String, Activity>();
        for (RepositoryModel model : models) {
            if (model.maxActivityCommits == -1 || !model.hasCommits || !model.lastChange.after(thresholdDate) || model.isCollectingGarbage) continue;
            Repository repository = GitBlit.self().getRepository(model.name);
            ArrayList<String> branches = new ArrayList<String>();
            if (StringUtils.isEmpty(objectId)) {
                for (RefModel local : JGitUtils.getLocalBranches(repository, true, -1)) {
                    branches.add(local.getName());
                }
            } else {
                branches.add(objectId);
            }
            Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(repository, model.showRemoteBranches);
            for (String branch : branches) {
                String shortName = branch;
                if (shortName.startsWith("refs/heads/")) {
                    shortName = shortName.substring("refs/heads/".length());
                }
                List<RevCommit> commits = JGitUtils.getRevLog(repository, branch, thresholdDate);
                if (model.maxActivityCommits > 0 && commits.size() > model.maxActivityCommits) {
                    commits = commits.subList(0, model.maxActivityCommits);
                }
                for (RevCommit commit : commits) {
                    Activity.RepositoryCommit commitModel;
                    Date date = JGitUtils.getCommitDate(commit);
                    String dateStr = df.format(date);
                    if (!activity.containsKey(dateStr)) {
                        cal.setTime(date);
                        cal.set(11, 0);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        activity.put(dateStr, new Activity(cal.getTime()));
                    }
                    if ((commitModel = ((Activity)activity.get(dateStr)).addCommit(model.name, shortName, commit)) == null) continue;
                    commitModel.setRefs(allRefs.get(commit.getId()));
                }
            }
            repository.close();
        }
        ArrayList<Activity> recentActivity = new ArrayList<Activity>(activity.values());
        return recentActivity;
    }

    public static GravatarProfile getGravatarProfileFromAddress(String emailaddress) throws IOException {
        return ActivityUtils.getGravatarProfile(StringUtils.getMD5(emailaddress.toLowerCase()));
    }

    public static String getGravatarThumbnailUrl(String email, int width) {
        if (width <= 0) {
            width = 50;
        }
        String emailHash = StringUtils.getMD5(email);
        String url = MessageFormat.format("https://www.gravatar.com/avatar/{0}?s={1,number,0}&d=identicon", emailHash, width);
        return url;
    }

    public static GravatarProfile getGravatarProfile(String hash) throws IOException {
        String url = MessageFormat.format("https://www.gravatar.com/{0}.json", hash);
        Type profileType = new TypeToken<Map<String, List<GravatarProfile>>>(){}.getType();
        Map profiles = null;
        try {
            profiles = (Map)JsonUtils.retrieveJson(url, profileType);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (profiles == null || profiles.size() == 0) {
            return null;
        }
        GravatarProfile profile = (GravatarProfile)((List)profiles.values().iterator().next()).get(0);
        return profile;
    }
}

