/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.Constants;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FederationModel
implements Serializable,
Comparable<FederationModel> {
    private static final long serialVersionUID = 1L;
    public String name;
    public String url;
    public String token;
    public String frequency;
    public String folder;
    public boolean bare;
    public boolean mirror;
    public boolean mergeAccounts;
    public boolean sendStatus;
    public boolean notifyOnError;
    public List<String> exclusions = new ArrayList<String>();
    public List<String> inclusions = new ArrayList<String>();
    public Date lastPull;
    public Date nextPull;
    private Map<String, Constants.FederationPullStatus> results = new ConcurrentHashMap<String, Constants.FederationPullStatus>();

    public FederationModel(String serverName) {
        this.name = serverName;
        this.bare = true;
        this.mirror = true;
        this.lastPull = new Date(0L);
        this.nextPull = new Date(0L);
    }

    public boolean isIncluded(RepositoryModel repository) {
        if (this.exclusions.contains("*")) {
            for (String name : this.inclusions) {
                if (!StringUtils.fuzzyMatch(repository.name, name)) continue;
                this.results.put(repository.name, Constants.FederationPullStatus.PENDING);
                return true;
            }
            this.results.put(repository.name, Constants.FederationPullStatus.EXCLUDED);
            return false;
        }
        for (String name : this.exclusions) {
            if (!StringUtils.fuzzyMatch(repository.name, name)) continue;
            this.results.put(repository.name, Constants.FederationPullStatus.EXCLUDED);
            return false;
        }
        this.results.put(repository.name, Constants.FederationPullStatus.PENDING);
        return true;
    }

    public void updateStatus(RepositoryModel repository, Constants.FederationPullStatus status) {
        if (!this.results.containsKey(repository.name)) {
            this.results.put(repository.name, Constants.FederationPullStatus.PENDING);
        }
        if (status != null) {
            this.results.put(repository.name, status);
        }
    }

    public List<RepositoryStatus> getStatusList() {
        ArrayList<RepositoryStatus> list = new ArrayList<RepositoryStatus>();
        for (Map.Entry<String, Constants.FederationPullStatus> entry : this.results.entrySet()) {
            list.add(new RepositoryStatus(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    public Constants.FederationPullStatus getLowestStatus() {
        if (this.results.size() == 0) {
            return Constants.FederationPullStatus.PENDING;
        }
        Constants.FederationPullStatus status = Constants.FederationPullStatus.MIRRORED;
        for (Constants.FederationPullStatus result : this.results.values()) {
            if (result.ordinal() >= status.ordinal()) continue;
            status = result;
        }
        return status;
    }

    public boolean isResultData() {
        return !this.url.toLowerCase().startsWith("http://") && !this.url.toLowerCase().startsWith("https://");
    }

    public String toString() {
        return "Federated " + this.name + " (" + this.url + ")";
    }

    @Override
    public int compareTo(FederationModel o) {
        boolean r1 = this.isResultData();
        boolean r2 = o.isResultData();
        if (r1 && r2 || !r1 && !r2) {
            return this.name.compareTo(o.name);
        }
        if (r1) {
            return 1;
        }
        return -1;
    }

    public static class RepositoryStatus
    implements Serializable,
    Comparable<RepositoryStatus> {
        private static final long serialVersionUID = 1L;
        public final String name;
        public final Constants.FederationPullStatus status;

        RepositoryStatus(String name, Constants.FederationPullStatus status) {
            this.name = name;
            this.status = status;
        }

        @Override
        public int compareTo(RepositoryStatus o) {
            if (this.status.equals((Object)o.status)) {
                return StringUtils.compareRepositoryNames(this.name, o.name);
            }
            return this.status.compareTo(o.status);
        }
    }
}

