/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.AuthenticationFilter;
import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.FeedEntryModel;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.SyndicationUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyndicationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient Logger logger = LoggerFactory.getLogger(SyndicationServlet.class);

    public static String asLink(String baseURL, String repository, String objectId, int length) {
        if (baseURL.length() > 0 && baseURL.charAt(baseURL.length() - 1) == '/') {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        StringBuilder url = new StringBuilder();
        url.append(baseURL);
        url.append("/feed/");
        url.append(repository);
        if (!StringUtils.isEmpty(objectId) || length > 0) {
            StringBuilder parameters = new StringBuilder("?");
            if (StringUtils.isEmpty(objectId)) {
                parameters.append("l=");
                parameters.append(length);
            } else {
                parameters.append("h=");
                parameters.append(objectId);
                if (length > 0) {
                    parameters.append("&l=");
                    parameters.append(length);
                }
            }
            url.append((CharSequence)parameters);
        }
        return url.toString();
    }

    public static String getTitle(String repository, String objectId) {
        String id = objectId;
        if (!StringUtils.isEmpty(id)) {
            if (id.startsWith("refs/heads/")) {
                id = id.substring("refs/heads/".length());
            } else if (id.startsWith("refs/remotes/")) {
                id = id.substring("refs/remotes/".length());
            } else if (id.startsWith("refs/tags/")) {
                id = id.substring("refs/tags/".length());
            }
        }
        return MessageFormat.format("{0} ({1})", repository, id);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean mountParameters;
        Constants.SearchType type;
        String servletUrl = request.getContextPath() + request.getServletPath();
        String url = request.getRequestURI().substring(servletUrl.length());
        if (url.charAt(0) == '/' && url.length() > 1) {
            url = url.substring(1);
        }
        String repositoryName = url;
        String objectId = request.getParameter("h");
        String l = request.getParameter("l");
        String page = request.getParameter("pg");
        String searchString = request.getParameter("s");
        Constants.SearchType searchType = Constants.SearchType.COMMIT;
        if (!StringUtils.isEmpty(request.getParameter("st")) && (type = Constants.SearchType.forName(request.getParameter("st"))) != null) {
            searchType = type;
        }
        int length = GitBlit.getInteger("web.syndicationEntries", 25);
        if (StringUtils.isEmpty(objectId)) {
            objectId = "HEAD";
        }
        if (!StringUtils.isEmpty(l)) {
            try {
                length = Integer.parseInt(l);
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        int offset = 0;
        if (!StringUtils.isEmpty(page)) {
            try {
                offset = length * Integer.parseInt(page);
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        response.setContentType("application/rss+xml; charset=UTF-8");
        boolean isProjectFeed = false;
        String feedName = null;
        String feedTitle = null;
        String feedDescription = null;
        List<String> repositories = null;
        if (repositoryName.indexOf(47) == -1 && !repositoryName.toLowerCase().endsWith(".git")) {
            ProjectModel project;
            UserModel user = null;
            if (request instanceof AuthenticationFilter.AuthenticatedRequest) {
                user = ((AuthenticationFilter.AuthenticatedRequest)request).getUser();
            }
            if ((project = GitBlit.self().getProjectModel(repositoryName, user)) != null) {
                isProjectFeed = true;
                repositories = new ArrayList<String>(project.repositories);
                feedName = project.name;
                feedTitle = project.title;
                feedDescription = project.description;
            }
        }
        if (repositories == null) {
            repositories = Arrays.asList(repositoryName);
        }
        String urlPattern = (mountParameters = GitBlit.getBoolean("web.mountParameters", true)) ? "{0}/commit/{1}/{2}" : "{0}/commit/?r={1}&h={2}";
        String gitblitUrl = HttpUtils.getGitblitURL(request);
        char fsc = GitBlit.getChar("web.forwardSlashCharacter", '/');
        ArrayList<FeedEntryModel> entries = new ArrayList();
        for (String name : repositories) {
            Repository repository = GitBlit.self().getRepository(name);
            RepositoryModel model = GitBlit.self().getRepositoryModel(name);
            if (repository == null) {
                if (!model.isCollectingGarbage) continue;
                this.logger.warn(MessageFormat.format("Temporarily excluding {0} from feed, busy collecting garbage", name));
                continue;
            }
            if (!isProjectFeed) {
                feedName = model.name;
                feedTitle = model.name;
                feedDescription = model.description;
            }
            List<RevCommit> commits = StringUtils.isEmpty(searchString) ? JGitUtils.getRevLog(repository, objectId, offset, length) : JGitUtils.searchRevlogs(repository, objectId, searchString, searchType, offset, length);
            Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(repository, model.showRemoteBranches);
            for (RevCommit commit : commits) {
                String message;
                FeedEntryModel entry = new FeedEntryModel();
                entry.title = commit.getShortMessage();
                entry.author = commit.getAuthorIdent().getName();
                entry.link = MessageFormat.format(urlPattern, gitblitUrl, StringUtils.encodeURL(model.name.replace('/', fsc)), commit.getName());
                entry.published = commit.getCommitterIdent().getWhen();
                entry.contentType = "text/html";
                entry.content = message = GitBlit.self().processCommitMessage(model.name, commit.getFullMessage());
                entry.repository = model.name;
                entry.branch = objectId;
                entry.tags = new ArrayList<String>();
                entry.tags.add("commit:" + commit.getName());
                for (RevCommit parent : commit.getParents()) {
                    entry.tags.add("parent:" + parent.getName());
                }
                List<RefModel> refs = allRefs.get(commit.getId());
                if (refs != null && refs.size() > 0) {
                    for (RefModel ref : refs) {
                        entry.tags.add("ref:" + ref.getName());
                    }
                }
                entries.add(entry);
            }
        }
        Collections.sort(entries);
        if (entries.size() > length) {
            entries = entries.subList(0, length);
        }
        String feedLink = isProjectFeed ? (mountParameters ? MessageFormat.format("{0}/project/{1}", gitblitUrl, StringUtils.encodeURL(feedName)) : MessageFormat.format("{0}/project/?p={1}", gitblitUrl, StringUtils.encodeURL(feedName))) : (mountParameters ? MessageFormat.format("{0}/summary/{1}", gitblitUrl, StringUtils.encodeURL(feedName)) : MessageFormat.format("{0}/summary/?r={1}", gitblitUrl, StringUtils.encodeURL(feedName)));
        try {
            SyndicationUtils.toRSS(gitblitUrl, feedLink, SyndicationServlet.getTitle(feedTitle, objectId), feedDescription, entries, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            this.logger.error("An error occurred during feed generation", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

