/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.GitBlitException;
import com.gitblit.JsonServlet;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.ServerSettings;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.RpcUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Repository;

public class RpcServlet
extends JsonServlet {
    private static final long serialVersionUID = 1L;
    public static final int PROTOCOL_VERSION = 5;

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Constants.RpcRequest reqType = Constants.RpcRequest.fromName(request.getParameter("req"));
        String objectName = request.getParameter("name");
        this.logger.info(MessageFormat.format("Rpc {0} request from {1}", new Object[]{reqType, request.getRemoteAddr()}));
        UserModel user = (UserModel)request.getUserPrincipal();
        boolean allowManagement = user != null && user.canAdmin() && GitBlit.getBoolean("web.enableRpcManagement", false);
        boolean allowAdmin = user != null && user.canAdmin() && GitBlit.getBoolean("web.enableRpcAdministration", false);
        Object result = null;
        if (Constants.RpcRequest.GET_PROTOCOL.equals((Object)reqType)) {
            result = 5;
        } else if (Constants.RpcRequest.LIST_REPOSITORIES.equals((Object)reqType)) {
            String gitblitUrl = HttpUtils.getGitblitURL(request);
            StringBuilder sb = new StringBuilder();
            sb.append(gitblitUrl);
            sb.append("/git/");
            sb.append("{0}");
            String cloneUrl = sb.toString();
            List<RepositoryModel> list = GitBlit.self().getRepositoryModels(user);
            HashMap<String, RepositoryModel> repositories = new HashMap<String, RepositoryModel>();
            for (RepositoryModel model : list) {
                String url = MessageFormat.format(cloneUrl, model.name);
                repositories.put(url, model);
            }
            result = repositories;
        } else if (Constants.RpcRequest.LIST_BRANCHES.equals((Object)reqType)) {
            HashMap localBranches = new HashMap();
            List<RepositoryModel> models = GitBlit.self().getRepositoryModels(user);
            for (RepositoryModel model : models) {
                if (!model.hasCommits) continue;
                if (model.isCollectingGarbage) {
                    this.logger.warn(MessageFormat.format("Temporarily excluding {0} from RPC, busy collecting garbage", model.name));
                    continue;
                }
                Repository repository = GitBlit.self().getRepository(model.name);
                List<RefModel> refs = JGitUtils.getLocalBranches(repository, false, -1);
                if (model.showRemoteBranches) {
                    refs.addAll(JGitUtils.getRemoteBranches(repository, false, -1));
                }
                if (refs.size() > 0) {
                    ArrayList<String> branches = new ArrayList<String>();
                    for (RefModel ref : refs) {
                        branches.add(ref.getName());
                    }
                    localBranches.put(model.name, branches);
                }
                repository.close();
            }
            result = localBranches;
        } else if (Constants.RpcRequest.LIST_USERS.equals((Object)reqType)) {
            List<String> names = GitBlit.self().getAllUsernames();
            ArrayList<UserModel> users = new ArrayList<UserModel>();
            for (String name : names) {
                users.add(GitBlit.self().getUserModel(name));
            }
            result = users;
        } else if (Constants.RpcRequest.LIST_TEAMS.equals((Object)reqType)) {
            List<String> names = GitBlit.self().getAllTeamnames();
            ArrayList<TeamModel> teams = new ArrayList<TeamModel>();
            for (String name : names) {
                teams.add(GitBlit.self().getTeamModel(name));
            }
            result = teams;
        } else if (Constants.RpcRequest.CREATE_REPOSITORY.equals((Object)reqType)) {
            RepositoryModel model = this.deserialize(request, response, RepositoryModel.class);
            try {
                GitBlit.self().updateRepositoryModel(model.name, model, true);
            }
            catch (GitBlitException e) {
                response.setStatus(500);
            }
        } else if (Constants.RpcRequest.EDIT_REPOSITORY.equals((Object)reqType)) {
            RepositoryModel model = this.deserialize(request, response, RepositoryModel.class);
            String repoName = objectName;
            if (repoName == null) {
                repoName = model.name;
            }
            try {
                GitBlit.self().updateRepositoryModel(repoName, model, false);
            }
            catch (GitBlitException e) {
                response.setStatus(500);
            }
        } else if (Constants.RpcRequest.DELETE_REPOSITORY.equals((Object)reqType)) {
            RepositoryModel model = this.deserialize(request, response, RepositoryModel.class);
            GitBlit.self().deleteRepositoryModel(model);
        } else if (Constants.RpcRequest.CREATE_USER.equals((Object)reqType)) {
            UserModel model = this.deserialize(request, response, UserModel.class);
            try {
                GitBlit.self().updateUserModel(model.username, model, true);
            }
            catch (GitBlitException e) {
                response.setStatus(500);
            }
        } else if (Constants.RpcRequest.EDIT_USER.equals((Object)reqType)) {
            UserModel model = this.deserialize(request, response, UserModel.class);
            String username = objectName;
            if (username == null) {
                username = model.username;
            }
            try {
                GitBlit.self().updateUserModel(username, model, false);
            }
            catch (GitBlitException e) {
                response.setStatus(500);
            }
        } else if (Constants.RpcRequest.DELETE_USER.equals((Object)reqType)) {
            UserModel model = this.deserialize(request, response, UserModel.class);
            if (!GitBlit.self().deleteUser(model.username)) {
                response.setStatus(500);
            }
        } else if (Constants.RpcRequest.CREATE_TEAM.equals((Object)reqType)) {
            TeamModel model = this.deserialize(request, response, TeamModel.class);
            try {
                GitBlit.self().updateTeamModel(model.name, model, true);
            }
            catch (GitBlitException e) {
                response.setStatus(500);
            }
        } else if (Constants.RpcRequest.EDIT_TEAM.equals((Object)reqType)) {
            TeamModel model = this.deserialize(request, response, TeamModel.class);
            String teamname = objectName;
            if (teamname == null) {
                teamname = model.name;
            }
            try {
                GitBlit.self().updateTeamModel(teamname, model, false);
            }
            catch (GitBlitException e) {
                response.setStatus(500);
            }
        } else if (Constants.RpcRequest.DELETE_TEAM.equals((Object)reqType)) {
            TeamModel model = this.deserialize(request, response, TeamModel.class);
            if (!GitBlit.self().deleteTeam(model.name)) {
                response.setStatus(500);
            }
        } else if (Constants.RpcRequest.LIST_REPOSITORY_MEMBERS.equals((Object)reqType)) {
            RepositoryModel model = GitBlit.self().getRepositoryModel(objectName);
            result = GitBlit.self().getRepositoryUsers(model);
        } else if (Constants.RpcRequest.SET_REPOSITORY_MEMBERS.equals((Object)reqType)) {
            response.setStatus(500);
        } else if (Constants.RpcRequest.LIST_REPOSITORY_MEMBER_PERMISSIONS.equals((Object)reqType)) {
            RepositoryModel model = GitBlit.self().getRepositoryModel(objectName);
            result = GitBlit.self().getUserAccessPermissions(model);
        } else if (Constants.RpcRequest.SET_REPOSITORY_MEMBER_PERMISSIONS.equals((Object)reqType)) {
            RepositoryModel model = GitBlit.self().getRepositoryModel(objectName);
            Collection permissions = (Collection)this.deserialize(request, response, RpcUtils.REGISTRANT_PERMISSIONS_TYPE);
            result = GitBlit.self().setUserAccessPermissions(model, permissions);
        } else if (Constants.RpcRequest.LIST_REPOSITORY_TEAMS.equals((Object)reqType)) {
            RepositoryModel model = GitBlit.self().getRepositoryModel(objectName);
            result = GitBlit.self().getRepositoryTeams(model);
        } else if (Constants.RpcRequest.SET_REPOSITORY_TEAMS.equals((Object)reqType)) {
            response.setStatus(500);
        } else if (Constants.RpcRequest.LIST_REPOSITORY_TEAM_PERMISSIONS.equals((Object)reqType)) {
            RepositoryModel model = GitBlit.self().getRepositoryModel(objectName);
            result = GitBlit.self().getTeamAccessPermissions(model);
        } else if (Constants.RpcRequest.SET_REPOSITORY_TEAM_PERMISSIONS.equals((Object)reqType)) {
            RepositoryModel model = GitBlit.self().getRepositoryModel(objectName);
            Collection permissions = (Collection)this.deserialize(request, response, RpcUtils.REGISTRANT_PERMISSIONS_TYPE);
            result = GitBlit.self().setTeamAccessPermissions(model, permissions);
        } else if (Constants.RpcRequest.LIST_FEDERATION_REGISTRATIONS.equals((Object)reqType)) {
            if (allowAdmin) {
                result = GitBlit.self().getFederationRegistrations();
            } else {
                response.sendError(405);
            }
        } else if (Constants.RpcRequest.LIST_FEDERATION_RESULTS.equals((Object)reqType)) {
            if (allowAdmin && GitBlit.canFederate()) {
                result = GitBlit.self().getFederationResultRegistrations();
            } else {
                response.sendError(405);
            }
        } else if (Constants.RpcRequest.LIST_FEDERATION_PROPOSALS.equals((Object)reqType)) {
            if (allowAdmin && GitBlit.canFederate()) {
                result = GitBlit.self().getPendingFederationProposals();
            } else {
                response.sendError(405);
            }
        } else if (Constants.RpcRequest.LIST_FEDERATION_SETS.equals((Object)reqType)) {
            if (allowAdmin && GitBlit.canFederate()) {
                String gitblitUrl = HttpUtils.getGitblitURL(request);
                result = GitBlit.self().getFederationSets(gitblitUrl);
            } else {
                response.sendError(405);
            }
        } else if (Constants.RpcRequest.LIST_SETTINGS.equals((Object)reqType)) {
            ServerSettings settings = GitBlit.self().getSettingsModel();
            if (allowAdmin) {
                result = settings;
            } else {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("web.siteName");
                keys.add("web.mountParameters");
                keys.add("web.syndicationEntries");
                if (allowManagement) {
                    keys.add("realm.minPasswordLength");
                    keys.add("realm.passwordStorage");
                    keys.add("federation.sets");
                }
                ServerSettings managementSettings = new ServerSettings();
                for (String key : keys) {
                    managementSettings.add(settings.get(key));
                }
                if (allowManagement) {
                    managementSettings.pushScripts = settings.pushScripts;
                }
                result = managementSettings;
            }
        } else if (Constants.RpcRequest.EDIT_SETTINGS.equals((Object)reqType)) {
            if (allowAdmin) {
                Map settings = (Map)this.deserialize(request, response, RpcUtils.SETTINGS_TYPE);
                GitBlit.self().updateSettings(settings);
            } else {
                response.sendError(405);
            }
        } else if (Constants.RpcRequest.LIST_STATUS.equals((Object)reqType)) {
            if (allowAdmin) {
                result = GitBlit.self().getStatus();
            } else {
                response.sendError(405);
            }
        } else if (Constants.RpcRequest.CLEAR_REPOSITORY_CACHE.equals((Object)reqType)) {
            if (allowManagement) {
                GitBlit.self().resetRepositoryListCache();
            } else {
                response.sendError(405);
            }
        }
        this.serialize(response, result);
    }
}

