/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.GitBlit;
import com.gitblit.models.RefModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient Logger logger = LoggerFactory.getLogger(PagesServlet.class);

    public static String asLink(String baseURL, String repository, String path) {
        if (baseURL.length() > 0 && baseURL.charAt(baseURL.length() - 1) == '/') {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        return baseURL + "/pages/" + repository + "/" + (path == null ? "" : "/" + path);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (path.toLowerCase().endsWith(".git")) {
            response.sendRedirect(request.getServletPath() + path + "/");
            return;
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        String repository = "";
        String resource = "";
        Repository r = null;
        int offset = 0;
        while (r == null) {
            int slash = path.indexOf(47, offset);
            repository = slash == -1 ? path : path.substring(0, slash);
            r = GitBlit.self().getRepository(repository, false);
            offset = slash + 1;
            if (offset > 0) {
                resource = path.substring(offset);
            }
            if (!repository.equals(path)) continue;
            break;
        }
        ServletContext context = request.getSession().getServletContext();
        try {
            if (r == null) {
                String mkd = MessageFormat.format("# Error\nSorry, no valid **repository** specified in this url: {0}!", repository);
                this.error(response, mkd);
                return;
            }
            RefModel pages = JGitUtils.getPagesBranch(r);
            RevCommit commit = JGitUtils.getCommit(r, pages.getObjectId().getName());
            if (commit == null) {
                String mkd = MessageFormat.format("# Error\nSorry, the repository {0} does not have a **gh-pages** branch!", repository);
                this.error(response, mkd);
                r.close();
                return;
            }
            response.setDateHeader("Last-Modified", JGitUtils.getCommitDate(commit).getTime());
            String[] encodings = GitBlit.getEncodings();
            RevTree tree = commit.getTree();
            byte[] content = null;
            if (StringUtils.isEmpty(resource)) {
                String[] files;
                for (String file : files = new String[]{"index.html", "index.htm", "index.mkd"}) {
                    content = JGitUtils.getStringContent(r, tree, file, encodings).getBytes("UTF-8");
                    if (content == null) continue;
                    resource = file;
                    response.setContentType("text/html; charset=UTF-8");
                    break;
                }
            } else {
                try {
                    String contentType = context.getMimeType(resource);
                    if (contentType == null) {
                        contentType = "text/plain";
                    }
                    content = contentType.startsWith("text") ? JGitUtils.getStringContent(r, tree, resource, encodings).getBytes("UTF-8") : JGitUtils.getByteContent(r, tree, resource);
                    response.setContentType(contentType);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (ArrayUtils.isEmpty(content)) {
                String custom404 = JGitUtils.getStringContent(r, tree, "404.html", encodings);
                if (!StringUtils.isEmpty(custom404)) {
                    content = custom404.getBytes("UTF-8");
                }
                if (ArrayUtils.isEmpty(content)) {
                    String str = MessageFormat.format("# Error\nSorry, the requested resource **{0}** was not found.", resource);
                    content = MarkdownUtils.transformMarkdown(str).getBytes("UTF-8");
                }
                try {
                    this.logger.warn("Pages 404: " + resource);
                    response.setStatus(404);
                    response.getOutputStream().write(content);
                    response.flushBuffer();
                }
                catch (Throwable t) {
                    this.logger.error("Failed to write page to client", t);
                }
                return;
            }
            for (String ext : GitBlit.getStrings("web.markdownExtensions")) {
                if (!resource.endsWith(ext)) continue;
                String mkd = new String(content, "UTF-8");
                content = MarkdownUtils.transformMarkdown(mkd).getBytes("UTF-8");
                break;
            }
            try {
                response.getOutputStream().write(content);
                response.flushBuffer();
            }
            catch (Throwable t) {
                this.logger.error("Failed to write page to client", t);
            }
            r.close();
        }
        catch (Throwable t) {
            this.logger.error("Failed to write page to client", t);
        }
    }

    private void error(HttpServletResponse response, String mkd) throws ServletException, IOException, ParseException {
        String content = MarkdownUtils.transformMarkdown(mkd);
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().write(content);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

