/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.IStoredSettings;
import com.gitblit.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailExecutor
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(MailExecutor.class);
    private final Queue<Message> queue = new ConcurrentLinkedQueue<Message>();
    private final Session session;
    private final IStoredSettings settings;

    public MailExecutor(IStoredSettings settings) {
        this.settings = settings;
        final String mailUser = settings.getString("mail.username", null);
        final String mailPassword = settings.getString("mail.password", null);
        boolean authenticate = !StringUtils.isEmpty(mailUser) && !StringUtils.isEmpty(mailPassword);
        String server2 = settings.getString("mail.server", "");
        if (StringUtils.isEmpty(server2)) {
            this.session = null;
            return;
        }
        int port = settings.getInteger("mail.port", 25);
        boolean isGMail = false;
        if (server2.equals("smtp.gmail.com")) {
            port = 465;
            isGMail = true;
        }
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", server2);
        props.setProperty("mail.smtp.port", String.valueOf(port));
        props.setProperty("mail.smtp.auth", String.valueOf(authenticate));
        props.setProperty("mail.smtp.auths", String.valueOf(authenticate));
        if (isGMail) {
            props.setProperty("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.socketFactory.port", String.valueOf(port));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        this.session = !StringUtils.isEmpty(mailUser) && !StringUtils.isEmpty(mailPassword) ? Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(mailUser, mailPassword);
                return passwordAuthentication;
            }
        }) : Session.getInstance((Properties)props);
    }

    public boolean isReady() {
        return this.session != null;
    }

    public Message createMessageForAdministrators() {
        List<String> toAddresses = this.settings.getStrings("mail.adminAddresses");
        if (toAddresses.size() == 0) {
            this.logger.warn("Can not notify administrators because no email addresses are defined!");
            return null;
        }
        return this.createMessage(toAddresses);
    }

    public Message createMessage(String ... toAddresses) {
        return this.createMessage(Arrays.asList(toAddresses));
    }

    public Message createMessage(List<String> toAddresses) {
        MimeMessage message = new MimeMessage(this.session);
        try {
            String fromAddress = this.settings.getString("mail.fromAddress", null);
            if (StringUtils.isEmpty(fromAddress)) {
                fromAddress = "gitblit@gitblit.com";
            }
            InternetAddress from = new InternetAddress(fromAddress, "Gitblit");
            message.setFrom((Address)from);
            HashSet<String> uniques = new HashSet<String>();
            for (String address : toAddresses) {
                uniques.add(address.toLowerCase());
            }
            Pattern validEmail = Pattern.compile("^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
            ArrayList<InternetAddress> tos = new ArrayList<InternetAddress>();
            for (String address : uniques) {
                if (StringUtils.isEmpty(address) || !validEmail.matcher(address).find()) continue;
                try {
                    tos.add(new InternetAddress(address));
                }
                catch (Throwable t) {}
            }
            message.setRecipients(Message.RecipientType.BCC, (Address[])tos.toArray(new InternetAddress[tos.size()]));
            message.setSentDate(new Date());
        }
        catch (Exception e) {
            this.logger.error("Failed to properly create message", (Throwable)e);
        }
        return message;
    }

    public boolean hasEmptyQueue() {
        return this.queue.isEmpty();
    }

    public boolean queue(Message message) {
        if (!this.isReady()) {
            return false;
        }
        try {
            message.saveChanges();
        }
        catch (Throwable t) {
            this.logger.error("Failed to save changes to message!", t);
        }
        this.queue.add(message);
        return true;
    }

    @Override
    public void run() {
        if (!this.queue.isEmpty() && this.session != null) {
            ArrayList<Message> failures = new ArrayList<Message>();
            Message message = null;
            while ((message = this.queue.poll()) != null) {
                try {
                    if (this.settings.getBoolean("mail.debug", false)) {
                        this.logger.info("send: " + StringUtils.trimString(message.getSubject(), 60));
                    }
                    Transport.send((Message)message);
                }
                catch (Throwable e) {
                    this.logger.error("Failed to send message", e);
                    failures.add(message);
                }
            }
            this.queue.addAll(failures);
        }
    }

    public void sendNow(Message message) throws Exception {
        Transport.send((Message)message);
    }
}

