/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.utils.FileUtils;
import com.gitblit.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IStoredSettings {
    protected final Logger logger;
    protected final Properties overrides = new Properties();

    public IStoredSettings(Class<? extends IStoredSettings> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    protected abstract Properties read();

    private Properties getSettings() {
        Properties props = this.read();
        props.putAll((Map<?, ?>)this.overrides);
        return props;
    }

    public List<String> getAllKeys(String startingWith) {
        ArrayList<String> keys = new ArrayList<String>();
        Properties props = this.getSettings();
        if (StringUtils.isEmpty(startingWith)) {
            keys.addAll(props.stringPropertyNames());
        } else {
            startingWith = startingWith.toLowerCase();
            for (Object o : props.keySet()) {
                String key = o.toString();
                if (!key.toLowerCase().startsWith(startingWith)) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value;
        Properties props = this.getSettings();
        if (props.containsKey(name) && !StringUtils.isEmpty(value = props.getProperty(name))) {
            return Boolean.parseBoolean(value.trim());
        }
        return defaultValue;
    }

    public int getInteger(String name, int defaultValue) {
        Properties props = this.getSettings();
        if (props.containsKey(name)) {
            try {
                String value = props.getProperty(name);
                if (!StringUtils.isEmpty(value)) {
                    return Integer.parseInt(value.trim());
                }
            }
            catch (NumberFormatException e) {
                this.logger.warn("Failed to parse integer for " + name + " using default of " + defaultValue);
            }
        }
        return defaultValue;
    }

    public long getLong(String name, long defaultValue) {
        Properties props = this.getSettings();
        if (props.containsKey(name)) {
            try {
                String value = props.getProperty(name);
                if (!StringUtils.isEmpty(value)) {
                    return Long.parseLong(value.trim());
                }
            }
            catch (NumberFormatException e) {
                this.logger.warn("Failed to parse long for " + name + " using default of " + defaultValue);
            }
        }
        return defaultValue;
    }

    public int getFilesize(String name, int defaultValue) {
        String val = this.getString(name, null);
        if (StringUtils.isEmpty(val)) {
            return defaultValue;
        }
        return FileUtils.convertSizeToInt(val, defaultValue);
    }

    public long getFilesize(String key, long defaultValue) {
        String val = this.getString(key, null);
        if (StringUtils.isEmpty(val)) {
            return defaultValue;
        }
        return FileUtils.convertSizeToLong(val, defaultValue);
    }

    public char getChar(String name, char defaultValue) {
        String value;
        Properties props = this.getSettings();
        if (props.containsKey(name) && !StringUtils.isEmpty(value = props.getProperty(name))) {
            return value.trim().charAt(0);
        }
        return defaultValue;
    }

    public String getString(String name, String defaultValue) {
        String value;
        Properties props = this.getSettings();
        if (props.containsKey(name) && (value = props.getProperty(name)) != null) {
            return value.trim();
        }
        return defaultValue;
    }

    public String getRequiredString(String name) {
        String value;
        Properties props = this.getSettings();
        if (props.containsKey(name) && (value = props.getProperty(name)) != null) {
            return value.trim();
        }
        throw new RuntimeException("Property (" + name + ") does not exist");
    }

    public List<String> getStrings(String name) {
        return this.getStrings(name, " ");
    }

    public List<String> getStrings(String name, String separator) {
        List<String> strings = new ArrayList<String>();
        Properties props = this.getSettings();
        if (props.containsKey(name)) {
            String value = props.getProperty(name);
            strings = StringUtils.getStringsFromValue(value, separator);
        }
        return strings;
    }

    public Map<String, String> getMap(String name) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String string : this.getStrings(name)) {
            String[] kvp = string.split("=", 2);
            String key = kvp[0];
            String value = kvp[1];
            map.put(key, value);
        }
        return map;
    }

    public void overrideSetting(String key, String value) {
        this.overrides.put(key, value);
    }

    public abstract boolean saveSettings(Map<String, String> var1);
}

