/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.ConfigUserService;
import com.gitblit.FileUserService;
import com.gitblit.GitBlit;
import com.gitblit.IStoredSettings;
import com.gitblit.IUserService;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.DeepCopier;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitUserService
implements IUserService {
    protected IUserService serviceImpl;
    private final Logger logger = LoggerFactory.getLogger(GitblitUserService.class);

    @Override
    public void setup(IStoredSettings settings) {
        File realmFile = GitBlit.getFileOrFolder("realm.userService", "users.conf");
        this.serviceImpl = this.createUserService(realmFile);
        this.logger.info("GUS delegating to " + ((Object)this.serviceImpl).toString());
    }

    protected IUserService createUserService(File realmFile) {
        IUserService service = null;
        if (realmFile.getName().toLowerCase().endsWith(".properties")) {
            service = new FileUserService(realmFile);
        } else if (realmFile.getName().toLowerCase().endsWith(".conf")) {
            service = new ConfigUserService(realmFile);
        }
        assert (service != null);
        if (!realmFile.exists()) {
            try {
                realmFile.createNewFile();
            }
            catch (IOException x) {
                this.logger.error(MessageFormat.format("COULD NOT CREATE REALM FILE {0}!", realmFile), (Throwable)x);
            }
            UserModel admin = new UserModel("admin");
            admin.password = "admin";
            admin.canAdmin = true;
            admin.excludeFromFederation = true;
            service.updateUserModel(admin);
        }
        if (service instanceof FileUserService) {
            File usersConfig = new File(realmFile.getParentFile(), "users.conf");
            if (!usersConfig.exists()) {
                this.logger.info(MessageFormat.format("Automatically creating {0} based on {1}", usersConfig.getAbsolutePath(), realmFile.getAbsolutePath()));
                ConfigUserService configService = new ConfigUserService(usersConfig);
                for (String username : service.getAllUsernames()) {
                    UserModel userModel = service.getUserModel(username);
                    configService.updateUserModel(userModel);
                }
            }
            this.logger.warn("Please consider using \"users.conf\" instead of the deprecated \"users.properties\" file");
        }
        return service;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean supportsCredentialChanges() {
        return this.serviceImpl.supportsCredentialChanges();
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return this.serviceImpl.supportsDisplayNameChanges();
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return this.serviceImpl.supportsEmailAddressChanges();
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return this.serviceImpl.supportsTeamMembershipChanges();
    }

    @Override
    public boolean supportsCookies() {
        return this.serviceImpl.supportsCookies();
    }

    @Override
    public String getCookie(UserModel model) {
        return this.serviceImpl.getCookie(model);
    }

    @Override
    public UserModel authenticate(char[] cookie) {
        return this.serviceImpl.authenticate(cookie);
    }

    @Override
    public UserModel authenticate(String username, char[] password) {
        return this.serviceImpl.authenticate(username, password);
    }

    @Override
    public void logout(UserModel user) {
        this.serviceImpl.logout(user);
    }

    @Override
    public UserModel getUserModel(String username) {
        return this.serviceImpl.getUserModel(username);
    }

    @Override
    public boolean updateUserModel(UserModel model) {
        return this.serviceImpl.updateUserModel(model);
    }

    @Override
    public boolean updateUserModels(List<UserModel> models) {
        return this.serviceImpl.updateUserModels(models);
    }

    @Override
    public boolean updateUserModel(String username, UserModel model) {
        if (this.supportsCredentialChanges()) {
            if (!this.supportsTeamMembershipChanges()) {
                UserModel existingModel = this.getUserModel(username);
                model = DeepCopier.copy(model);
                model.teams.clear();
                model.teams.addAll(existingModel.teams);
            }
            return this.serviceImpl.updateUserModel(username, model);
        }
        if (model.username.equals(username)) {
            model.password = null;
            if (!this.supportsTeamMembershipChanges()) {
                UserModel existingModel = this.getUserModel(username);
                model = DeepCopier.copy(model);
                model.teams.clear();
                model.teams.addAll(existingModel.teams);
            }
            return this.serviceImpl.updateUserModel(username, model);
        }
        this.logger.error("Users can not be renamed!");
        return false;
    }

    @Override
    public boolean deleteUserModel(UserModel model) {
        return this.serviceImpl.deleteUserModel(model);
    }

    @Override
    public boolean deleteUser(String username) {
        return this.serviceImpl.deleteUser(username);
    }

    @Override
    public List<String> getAllUsernames() {
        return this.serviceImpl.getAllUsernames();
    }

    @Override
    public List<UserModel> getAllUsers() {
        return this.serviceImpl.getAllUsers();
    }

    @Override
    public List<String> getAllTeamNames() {
        return this.serviceImpl.getAllTeamNames();
    }

    @Override
    public List<TeamModel> getAllTeams() {
        return this.serviceImpl.getAllTeams();
    }

    @Override
    public List<String> getTeamnamesForRepositoryRole(String role) {
        return this.serviceImpl.getTeamnamesForRepositoryRole(role);
    }

    @Override
    @Deprecated
    public boolean setTeamnamesForRepositoryRole(String role, List<String> teamnames) {
        return this.serviceImpl.setTeamnamesForRepositoryRole(role, teamnames);
    }

    @Override
    public TeamModel getTeamModel(String teamname) {
        return this.serviceImpl.getTeamModel(teamname);
    }

    @Override
    public boolean updateTeamModel(TeamModel model) {
        return this.serviceImpl.updateTeamModel(model);
    }

    @Override
    public boolean updateTeamModels(List<TeamModel> models) {
        return this.serviceImpl.updateTeamModels(models);
    }

    @Override
    public boolean updateTeamModel(String teamname, TeamModel model) {
        if (!this.supportsTeamMembershipChanges()) {
            TeamModel existingModel = this.getTeamModel(teamname);
            model = DeepCopier.copy(model);
            model.users.clear();
            model.users.addAll(existingModel.users);
        }
        return this.serviceImpl.updateTeamModel(teamname, model);
    }

    @Override
    public boolean deleteTeamModel(TeamModel model) {
        return this.serviceImpl.deleteTeamModel(model);
    }

    @Override
    public boolean deleteTeam(String teamname) {
        return this.serviceImpl.deleteTeam(teamname);
    }

    @Override
    public List<String> getUsernamesForRepositoryRole(String role) {
        return this.serviceImpl.getUsernamesForRepositoryRole(role);
    }

    @Override
    @Deprecated
    public boolean setUsernamesForRepositoryRole(String role, List<String> usernames) {
        return this.serviceImpl.setUsernamesForRepositoryRole(role, usernames);
    }

    @Override
    public boolean renameRepositoryRole(String oldRole, String newRole) {
        return this.serviceImpl.renameRepositoryRole(oldRole, newRole);
    }

    @Override
    public boolean deleteRepositoryRole(String role) {
        return this.serviceImpl.deleteRepositoryRole(role);
    }
}

