/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitTrustManager
implements X509TrustManager {
    private static final Logger logger = LoggerFactory.getLogger(GitblitTrustManager.class);
    private final X509TrustManager delegate;
    private final File caRevocationList;
    private final AtomicLong lastModified = new AtomicLong(0L);
    private volatile X509CRL crl;

    public GitblitTrustManager(X509TrustManager delegate, File crlFile) {
        this.delegate = delegate;
        this.caRevocationList = crlFile;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate cert = chain[0];
        if (this.isRevoked(cert)) {
            String message = MessageFormat.format("Rejecting revoked certificate {0,number,0} for {1}", cert.getSerialNumber(), cert.getSubjectDN().getName());
            logger.warn(message);
            throw new CertificateException(message);
        }
        this.delegate.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    protected boolean isRevoked(X509Certificate cert) {
        if (!this.caRevocationList.exists()) {
            return false;
        }
        this.read();
        if (this.crl.isRevoked(cert)) {
            return true;
        }
        X509CRLEntry entry = this.crl.getRevokedCertificate(cert.getSerialNumber());
        if (entry != null) {
            logger.warn("Certificate issuer does not match CRL issuer, but serial number has been revoked!");
            logger.warn("   cert issuer = " + cert.getIssuerX500Principal());
            logger.warn("   crl issuer  = " + this.crl.getIssuerX500Principal());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void read() {
        if (this.lastModified.get() == this.caRevocationList.lastModified()) {
            return;
        }
        logger.info("Reloading CRL from " + this.caRevocationList.getAbsolutePath());
        FileInputStream inStream = null;
        try {
            X509CRL list;
            inStream = new FileInputStream(this.caRevocationList);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.crl = list = (X509CRL)cf.generateCRL(inStream);
            this.lastModified.set(this.caRevocationList.lastModified());
        }
        catch (Exception e) {
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (Exception e) {}
            }
        }
    }
}

