/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.GitFilter;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ClientLogger;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.http.server.resolver.DefaultReceivePackFactory;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitServlet
extends org.eclipse.jgit.http.server.GitServlet {
    private static final long serialVersionUID = 1L;
    private GroovyScriptEngine gse;
    private File groovyDir;

    public void init(ServletConfig config) throws ServletException {
        this.groovyDir = GitBlit.getGroovyScriptsFolder();
        try {
            File grapeRoot = new File(GitBlit.getString("groovy.grapeFolder", "groovy/grape")).getAbsoluteFile();
            grapeRoot.mkdirs();
            System.setProperty("grape.root", grapeRoot.getAbsolutePath());
            this.gse = new GroovyScriptEngine(this.groovyDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ServletException("Failed to instantiate Groovy Script Engine!", (Throwable)e);
        }
        this.setReceivePackFactory((ReceivePackFactory)new DefaultReceivePackFactory(){

            public ReceivePack create(HttpServletRequest req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                String repositoryName = req.getPathInfo().substring(1);
                repositoryName = GitFilter.getRepositoryName(repositoryName);
                GitblitReceiveHook hook = new GitblitReceiveHook();
                hook.repositoryName = repositoryName;
                hook.gitblitUrl = HttpUtils.getGitblitURL(req);
                ReceivePack rp = super.create(req, db);
                rp.setPreReceiveHook((PreReceiveHook)hook);
                rp.setPostReceiveHook((PostReceiveHook)hook);
                PersonIdent person = rp.getRefLogIdent();
                UserModel user = GitBlit.self().getUserModel(person.getName());
                if (user == null) {
                    user = new UserModel(person.getName());
                }
                RepositoryModel repository = GitBlit.self().getRepositoryModel(repositoryName);
                rp.setAllowCreates(user.canCreateRef(repository));
                rp.setAllowDeletes(user.canDeleteRef(repository));
                rp.setAllowNonFastForwards(user.canRewindRef(repository));
                if (repository.isFrozen) {
                    throw new ServiceNotEnabledException();
                }
                return rp;
            }
        });
        super.init((ServletConfig)new GitblitServletConfig(config));
    }

    private class GitblitReceiveHook
    implements PreReceiveHook,
    PostReceiveHook {
        protected final Logger logger = LoggerFactory.getLogger(GitblitReceiveHook.class);
        protected String repositoryName;
        protected String gitblitUrl;

        private GitblitReceiveHook() {
        }

        public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
            RepositoryModel repository = GitBlit.self().getRepositoryModel(this.repositoryName);
            UserModel user = this.getUserModel(rp);
            if (repository.accessRestriction.atLeast(Constants.AccessRestrictionType.PUSH) && repository.verifyCommitter) {
                if (StringUtils.isEmpty(user.emailAddress)) {
                    this.logger.warn(MessageFormat.format("Consider setting an email address for {0} ({1}) to improve committer verification.", user.getDisplayName(), user.username));
                }
                for (ReceiveCommand cmd : commands) {
                    try {
                        List<RevCommit> commits = JGitUtils.getRevLog(rp.getRepository(), cmd.getOldId().name(), cmd.getNewId().name());
                        for (RevCommit commit : commits) {
                            PersonIdent committer = commit.getCommitterIdent();
                            if (user.is(committer.getName(), committer.getEmailAddress())) continue;
                            String reason = StringUtils.isEmpty(user.emailAddress) ? MessageFormat.format("{0} by {1} <{2}> was not committed by {3} ({4})", commit.getId().name(), committer.getName(), StringUtils.isEmpty(committer.getEmailAddress()) ? "?" : committer.getEmailAddress(), user.getDisplayName(), user.username) : MessageFormat.format("{0} by {1} <{2}> was not committed by {3} ({4}) <{5}>", commit.getId().name(), committer.getName(), StringUtils.isEmpty(committer.getEmailAddress()) ? "?" : committer.getEmailAddress(), user.getDisplayName(), user.username, user.emailAddress);
                            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, reason);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to verify commits were made by pushing user", (Throwable)e);
                    }
                }
            }
            LinkedHashSet<String> scripts = new LinkedHashSet<String>();
            scripts.addAll(GitBlit.self().getPreReceiveScriptsInherited(repository));
            scripts.addAll(repository.preReceiveScripts);
            this.runGroovy(repository, user, commands, rp, scripts);
            for (ReceiveCommand cmd : commands) {
                if (ReceiveCommand.Result.NOT_ATTEMPTED.equals((Object)cmd.getResult())) continue;
                this.logger.warn(MessageFormat.format("{0} {1} because \"{2}\"", cmd.getNewId().getName(), cmd.getResult(), cmd.getMessage()));
            }
        }

        public void onPostReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
            if (commands.size() == 0) {
                this.logger.info("skipping post-receive hooks, no refs created, updated, or removed");
                return;
            }
            RepositoryModel repository = GitBlit.self().getRepositoryModel(this.repositoryName);
            LinkedHashSet<String> scripts = new LinkedHashSet<String>();
            scripts.addAll(GitBlit.self().getPostReceiveScriptsInherited(repository));
            scripts.addAll(repository.postReceiveScripts);
            UserModel user = this.getUserModel(rp);
            this.runGroovy(repository, user, commands, rp, scripts);
            for (ReceiveCommand cmd : commands) {
                if (!ReceiveCommand.Result.OK.equals((Object)cmd.getResult())) continue;
                switch (cmd.getType()) {
                    case DELETE: {
                        this.logger.info(MessageFormat.format("{0} DELETED {1} in {2} ({3})", user.username, cmd.getRefName(), repository.name, cmd.getOldId().name()));
                        break;
                    }
                    case CREATE: {
                        this.logger.info(MessageFormat.format("{0} CREATED {1} in {2}", user.username, cmd.getRefName(), repository.name));
                        break;
                    }
                    case UPDATE_NONFASTFORWARD: {
                        this.logger.info(MessageFormat.format("{0} UPDATED NON-FAST-FORWARD {1} in {2} (from {3} to {4})", user.username, cmd.getRefName(), repository.name, cmd.getOldId().name(), cmd.getNewId().name()));
                        break;
                    }
                }
            }
        }

        protected UserModel getUserModel(ReceivePack rp) {
            PersonIdent person = rp.getRefLogIdent();
            UserModel user = GitBlit.self().getUserModel(person.getName());
            if (user == null) {
                user = new UserModel(person.getName());
                user.isAuthenticated = false;
            }
            return user;
        }

        protected void runGroovy(RepositoryModel repository, UserModel user, Collection<ReceiveCommand> commands, ReceivePack rp, Set<String> scripts) {
            if (scripts == null || scripts.size() == 0) {
                return;
            }
            Binding binding = new Binding();
            binding.setVariable("gitblit", (Object)GitBlit.self());
            binding.setVariable("repository", (Object)repository);
            binding.setVariable("receivePack", (Object)rp);
            binding.setVariable("user", (Object)user);
            binding.setVariable("commands", commands);
            binding.setVariable("url", (Object)this.gitblitUrl);
            binding.setVariable("logger", (Object)this.logger);
            binding.setVariable("clientLogger", (Object)new ClientLogger(rp));
            for (String script : scripts) {
                if (StringUtils.isEmpty(script)) continue;
                File file = new File(GitServlet.this.groovyDir, script);
                if (!file.exists() && !script.toLowerCase().endsWith(".groovy") && (file = new File(GitServlet.this.groovyDir, script + ".groovy")).exists()) {
                    script = file.getName();
                }
                try {
                    Object result = GitServlet.this.gse.run(script, binding);
                    if (!(result instanceof Boolean) || ((Boolean)result).booleanValue()) continue;
                    this.logger.error(MessageFormat.format("Groovy script {0} has failed!  Hook scripts aborted.", script));
                    break;
                }
                catch (Exception e) {
                    this.logger.error(MessageFormat.format("Failed to execute Groovy script {0}", script), (Throwable)e);
                }
            }
        }

        protected void runNativeScript(ReceivePack rp, String script, Collection<ReceiveCommand> commands) {
            Repository repository = rp.getRepository();
            File scriptFile = new File(repository.getDirectory(), script);
            int resultCode = 0;
            if (scriptFile.exists()) {
                try {
                    this.logger.debug("executing " + scriptFile);
                    Process process = Runtime.getRuntime().exec(scriptFile.getAbsolutePath(), null, repository.getDirectory());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                    for (ReceiveCommand command : commands) {
                        switch (command.getType()) {
                            case UPDATE: {
                                writer.append(MessageFormat.format("{0} {1} {2}\n", command.getOldId().getName(), command.getNewId().getName(), command.getRefName()));
                                break;
                            }
                            case CREATE: {
                                writer.append(MessageFormat.format("40 {0} {1}\n", command.getNewId().getName(), command.getRefName()));
                            }
                        }
                    }
                    resultCode = process.waitFor();
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append('\n');
                    }
                    this.logger.debug(sb.toString());
                }
                catch (Throwable e) {
                    resultCode = -1;
                    this.logger.error(MessageFormat.format("Failed to execute {0}", scriptFile.getAbsolutePath()), e);
                }
            }
            if (resultCode != 0) {
                for (ReceiveCommand command : commands) {
                    command.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format("Native script {0} rejected push or failed", scriptFile.getAbsolutePath()));
                }
            }
        }
    }

    private class GitblitServletConfig
    implements ServletConfig {
        final ServletConfig config;

        GitblitServletConfig(ServletConfig config) {
            this.config = config;
        }

        public String getServletName() {
            return this.config.getServletName();
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        public String getInitParameter(String name) {
            if (name.equals("base-path")) {
                return GitBlit.getRepositoriesFolder().getAbsolutePath();
            }
            if (name.equals("export-all")) {
                return "1";
            }
            return this.config.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.config.getInitParameterNames();
        }
    }
}

