/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.GitBlit;
import com.gitblit.IStoredSettings;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.FileUtils;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.GC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCExecutor
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(GCExecutor.class);
    private final IStoredSettings settings;
    private AtomicBoolean running = new AtomicBoolean(false);
    private AtomicBoolean forceClose = new AtomicBoolean(false);
    private final Map<String, GCStatus> gcCache = new ConcurrentHashMap<String, GCStatus>();

    public GCExecutor(IStoredSettings settings) {
        this.settings = settings;
    }

    public boolean isReady() {
        return this.settings.getBoolean("git.enableGarbageCollection", false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean lock(String repositoryName) {
        return this.setGCStatus(repositoryName, GCStatus.COLLECTING);
    }

    private boolean setGCStatus(String repositoryName, GCStatus status) {
        String key = repositoryName.toLowerCase();
        if (this.gcCache.containsKey(key) && this.gcCache.get(key).exceeds(GCStatus.READY)) {
            return false;
        }
        this.gcCache.put(key, status);
        return true;
    }

    public boolean isCollectingGarbage(String repositoryName) {
        String key = repositoryName.toLowerCase();
        return this.gcCache.containsKey(key) && GCStatus.COLLECTING.equals((Object)this.gcCache.get(key));
    }

    public void releaseLock(String repositoryName) {
        this.gcCache.put(repositoryName.toLowerCase(), GCStatus.READY);
    }

    public void close() {
        this.forceClose.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isReady()) {
            return;
        }
        this.running.set(true);
        Date now = new Date();
        for (String repositoryName : GitBlit.self().getRepositoryList()) {
            block22: {
                FileRepository repository;
                block23: {
                    RepositoryModel model;
                    boolean garbageCollected;
                    block19: {
                        block20: {
                            block21: {
                                block16: {
                                    block17: {
                                        block18: {
                                            block13: {
                                                block14: {
                                                    block15: {
                                                        if (this.forceClose.get()) break;
                                                        if (this.isCollectingGarbage(repositoryName)) {
                                                            this.logger.warn(MessageFormat.format("Already collecting garbage from {0}?!?", repositoryName));
                                                            continue;
                                                        }
                                                        garbageCollected = false;
                                                        model = null;
                                                        repository = null;
                                                        model = GitBlit.self().getRepositoryModel(repositoryName);
                                                        repository = (FileRepository)GitBlit.self().getRepository(repositoryName);
                                                        if (repository != null) break block13;
                                                        this.logger.warn(MessageFormat.format("GCExecutor is missing repository {0}?!?", repositoryName));
                                                        if (repository == null) break block14;
                                                        if (!garbageCollected) break block15;
                                                        model.lastGC = new Date();
                                                        GitBlit.self().updateConfiguration((Repository)repository, model);
                                                    }
                                                    repository.close();
                                                }
                                                this.releaseLock(repositoryName);
                                                this.logger.debug(MessageFormat.format("GCExecutor released GC lock for {0}", repositoryName));
                                                continue;
                                            }
                                            if (this.isRepositoryIdle(repository)) break block16;
                                            this.logger.debug(MessageFormat.format("GCExecutor is skipping {0} because it is not idle", repositoryName));
                                            if (repository == null) break block17;
                                            if (!garbageCollected) break block18;
                                            model.lastGC = new Date();
                                            GitBlit.self().updateConfiguration((Repository)repository, model);
                                        }
                                        repository.close();
                                    }
                                    this.releaseLock(repositoryName);
                                    this.logger.debug(MessageFormat.format("GCExecutor released GC lock for {0}", repositoryName));
                                    continue;
                                }
                                if (this.setGCStatus(repositoryName, GCStatus.COLLECTING)) break block19;
                                this.logger.warn(MessageFormat.format("Can not acquire GC lock for {0}, skipping", repositoryName));
                                if (repository == null) break block20;
                                if (!garbageCollected) break block21;
                                model.lastGC = new Date();
                                GitBlit.self().updateConfiguration((Repository)repository, model);
                            }
                            repository.close();
                        }
                        this.releaseLock(repositoryName);
                        this.logger.debug(MessageFormat.format("GCExecutor released GC lock for {0}", repositoryName));
                        continue;
                    }
                    try {
                        boolean hasGarbage;
                        this.logger.debug(MessageFormat.format("GCExecutor locked idle repository {0}", repositoryName));
                        GC gc = new GC(repository);
                        GC.RepoStatistics stats = gc.getStatistics();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(model.lastGC);
                        cal.set(11, 0);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        cal.add(5, model.gcPeriod);
                        Date gcDate = cal.getTime();
                        boolean shouldCollectGarbage = now.after(gcDate);
                        long gcThreshold = FileUtils.convertSizeToLong(model.gcThreshold, 512000L);
                        boolean hasEnoughGarbage = stats.sizeOfLooseObjects >= gcThreshold;
                        boolean bl = hasGarbage = stats.sizeOfLooseObjects > 0L;
                        if (hasGarbage && (hasEnoughGarbage || shouldCollectGarbage)) {
                            long looseKB = stats.sizeOfLooseObjects / 1024L;
                            this.logger.info(MessageFormat.format("Collecting {1} KB of loose objects from {0}", repositoryName, looseKB));
                            gc.gc();
                            garbageCollected = true;
                        }
                        if (repository == null) break block22;
                        if (!garbageCollected) break block23;
                        model.lastGC = new Date();
                        GitBlit.self().updateConfiguration((Repository)repository, model);
                    }
                    catch (Exception e) {
                        block24: {
                            block25: {
                                try {
                                    this.logger.error("Error collecting garbage in " + repositoryName, (Throwable)e);
                                    if (repository == null) break block24;
                                    if (!garbageCollected) break block25;
                                    model.lastGC = new Date();
                                    GitBlit.self().updateConfiguration((Repository)repository, model);
                                }
                                catch (Throwable throwable) {
                                    if (repository != null) {
                                        if (garbageCollected) {
                                            model.lastGC = new Date();
                                            GitBlit.self().updateConfiguration((Repository)repository, model);
                                        }
                                        repository.close();
                                    }
                                    this.releaseLock(repositoryName);
                                    this.logger.debug(MessageFormat.format("GCExecutor released GC lock for {0}", repositoryName));
                                    throw throwable;
                                }
                            }
                            repository.close();
                        }
                        this.releaseLock(repositoryName);
                        this.logger.debug(MessageFormat.format("GCExecutor released GC lock for {0}", repositoryName));
                        continue;
                    }
                }
                repository.close();
            }
            this.releaseLock(repositoryName);
            this.logger.debug(MessageFormat.format("GCExecutor released GC lock for {0}", repositoryName));
        }
        this.running.set(false);
    }

    private boolean isRepositoryIdle(FileRepository repository) {
        try {
            Field useCnt = Repository.class.getDeclaredField("useCnt");
            useCnt.setAccessible(true);
            int useCount = ((AtomicInteger)useCnt.get(repository)).get();
            return useCount == 2;
        }
        catch (Exception e) {
            this.logger.warn(MessageFormat.format("Failed to reflectively determine use count for repository {0}", repository.getDirectory().getPath()), (Throwable)e);
            return false;
        }
    }

    public static enum GCStatus {
        READY,
        COLLECTING;


        public boolean exceeds(GCStatus s) {
            return this.ordinal() > s.ordinal();
        }
    }
}

