/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.gitblit.Constants;
import com.gitblit.FederationPullExecutor;
import com.gitblit.FileSettings;
import com.gitblit.GitBlit;
import com.gitblit.models.FederationModel;
import com.gitblit.utils.FederationUtils;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;

public class FederationClient {
    public static void main(String[] args) {
        Params params = new Params();
        JCommander jc = new JCommander((Object)params);
        try {
            jc.parse(args);
        }
        catch (ParameterException t) {
            FederationClient.usage(jc, t);
        }
        FileSettings settings = new FileSettings(params.registrationsFile);
        ArrayList<FederationModel> registrations = new ArrayList<FederationModel>();
        if (StringUtils.isEmpty(params.url)) {
            registrations.addAll(FederationUtils.getFederationRegistrations(settings));
        } else {
            if (StringUtils.isEmpty(params.token)) {
                System.out.println("Must specify --token parameter!");
                System.exit(0);
            }
            FederationModel model = new FederationModel("Gitblit");
            model.url = params.url;
            model.token = params.token;
            model.mirror = params.mirror;
            model.bare = params.bare;
            model.frequency = params.frequency;
            model.folder = "";
            registrations.add(model);
        }
        if (registrations.size() == 0) {
            System.out.println("No Federation Registrations!  Nothing to do.");
            System.exit(0);
        }
        System.out.println("Gitblit Federation Client v1.2.0 (2012-12-31)");
        if (!StringUtils.isEmpty(params.repositoriesFolder)) {
            settings.overrideSetting("git.repositoriesFolder", new File(params.repositoriesFolder).getAbsolutePath());
        }
        GitBlit.self().configureContext(settings, false);
        FederationPullExecutor executor = new FederationPullExecutor(registrations, params.isDaemon);
        executor.run();
        if (!params.isDaemon) {
            System.out.println("Finished.");
            System.exit(0);
        }
    }

    private static void usage(JCommander jc, ParameterException t) {
        System.out.println(Constants.getGitBlitVersion());
        System.out.println();
        if (t != null) {
            System.out.println(t.getMessage());
            System.out.println();
        }
        if (jc != null) {
            jc.usage();
        }
        System.exit(0);
    }

    @Parameters(separators=" ")
    private static class Params {
        @Parameter(names={"--registrations"}, description="Gitblit Federation Registrations File", required=false)
        public String registrationsFile = "federation.properties";
        @Parameter(names={"--daemon"}, description="Runs in daemon mode to schedule and pull repositories", required=false)
        public boolean isDaemon;
        @Parameter(names={"--url"}, description="URL of Gitblit instance to mirror from", required=false)
        public String url;
        @Parameter(names={"--mirror"}, description="Mirror repositories", required=false)
        public boolean mirror;
        @Parameter(names={"--bare"}, description="Create bare repositories", required=false)
        public boolean bare;
        @Parameter(names={"--token"}, description="Federation Token", required=false)
        public String token;
        @Parameter(names={"--frequency"}, description="Period to wait between pull attempts (requires --daemon)", required=false)
        public String frequency = "60 mins";
        @Parameter(names={"--repositoriesFolder"}, description="Destination folder for cloned repositories", required=false)
        public String repositoriesFolder;

        private Params() {
        }
    }
}

