/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Constants {
    public static final String NAME = "Gitblit";
    public static final String FULL_NAME = "Gitblit - a pure Java Git solution";
    public static final String VERSION = "1.2.0";
    public static final String VERSION_DATE = "2012-12-31";
    public static final String JGIT_VERSION = "JGit 2.2.0 (201212191850-r)";
    public static final String ADMIN_ROLE = "#admin";
    public static final String FORK_ROLE = "#fork";
    public static final String CREATE_ROLE = "#create";
    public static final String NOT_FEDERATED_ROLE = "#notfederated";
    public static final String NO_ROLE = "#none";
    public static final String PROPERTIES_FILE = "gitblit.properties";
    public static final String GIT_PATH = "/git/";
    public static final String ZIP_PATH = "/zip/";
    public static final String SYNDICATION_PATH = "/feed/";
    public static final String FEDERATION_PATH = "/federation/";
    public static final String RPC_PATH = "/rpc/";
    public static final String PAGES = "/pages/";
    public static final String BORDER = "***********************************************************";
    public static final String FEDERATION_USER = "$gitblit";
    public static final String PROPOSAL_EXT = ".json";
    public static final String ENCODING = "UTF-8";
    public static final int LEN_SHORTLOG = 78;
    public static final int LEN_SHORTLOG_REFS = 60;
    public static final String DEFAULT_BRANCH = "default";
    public static final String CONFIG_GITBLIT = "gitblit";
    public static final String CONFIG_CUSTOM_FIELDS = "customFields";
    public static final String ISO8601 = "yyyy-MM-dd'T'HH:mm:ssZ";

    public static String getGitBlitVersion() {
        return "Gitblit v1.2.0";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Unused {
    }

    public static enum AuthenticationType {
        CREDENTIALS,
        COOKIE,
        CERTIFICATE,
        CONTAINER;


        public boolean isStandard() {
            return this.ordinal() <= COOKIE.ordinal();
        }
    }

    public static enum GCStatus {
        READY,
        COLLECTING;


        public boolean exceeds(GCStatus s) {
            return this.ordinal() > s.ordinal();
        }
    }

    public static enum PermissionType {
        MISSING,
        EXPLICIT,
        TEAM,
        REGEX,
        OWNER,
        ADMINISTRATOR;

    }

    public static enum RegistrantType {
        REPOSITORY,
        USER,
        TEAM;

    }

    public static enum AccessPermission {
        NONE("N"),
        EXCLUDE("X"),
        VIEW("V"),
        CLONE("R"),
        PUSH("RW"),
        CREATE("RWC"),
        DELETE("RWD"),
        REWIND("RW+"),
        OWNER("RW+");

        public static final AccessPermission[] NEWPERMISSIONS;
        public static AccessPermission LEGACY;
        public final String code;

        private AccessPermission(String code) {
            this.code = code;
        }

        public boolean atLeast(AccessPermission perm) {
            return this.ordinal() >= perm.ordinal();
        }

        public boolean exceeds(AccessPermission perm) {
            return this.ordinal() > perm.ordinal();
        }

        public String asRole(String repository) {
            return this.code + ":" + repository;
        }

        public String toString() {
            return this.code;
        }

        public static AccessPermission permissionFromRole(String role) {
            String[] fields = role.split(":", 2);
            if (fields.length == 1) {
                return LEGACY;
            }
            return AccessPermission.fromCode(fields[0]);
        }

        public static String repositoryFromRole(String role) {
            String[] fields = role.split(":", 2);
            if (fields.length == 1) {
                return role;
            }
            return fields[1];
        }

        public static AccessPermission fromCode(String code) {
            for (AccessPermission perm : AccessPermission.values()) {
                if (!perm.code.equalsIgnoreCase(code)) continue;
                return perm;
            }
            return NONE;
        }

        static {
            NEWPERMISSIONS = new AccessPermission[]{EXCLUDE, VIEW, CLONE, PUSH, CREATE, DELETE, REWIND};
            LEGACY = REWIND;
        }
    }

    public static enum SearchObjectType {
        commit,
        blob,
        issue;


        static SearchObjectType fromName(String name) {
            for (SearchObjectType value : SearchObjectType.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            return null;
        }
    }

    public static enum SearchType {
        AUTHOR,
        COMMITTER,
        COMMIT;


        public static SearchType forName(String name) {
            for (SearchType type : SearchType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return COMMIT;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum RpcRequest {
        CLEAR_REPOSITORY_CACHE,
        GET_PROTOCOL,
        LIST_REPOSITORIES,
        LIST_BRANCHES,
        LIST_SETTINGS,
        CREATE_REPOSITORY,
        EDIT_REPOSITORY,
        DELETE_REPOSITORY,
        LIST_USERS,
        CREATE_USER,
        EDIT_USER,
        DELETE_USER,
        LIST_TEAMS,
        CREATE_TEAM,
        EDIT_TEAM,
        DELETE_TEAM,
        LIST_REPOSITORY_MEMBERS,
        SET_REPOSITORY_MEMBERS,
        LIST_REPOSITORY_TEAMS,
        SET_REPOSITORY_TEAMS,
        LIST_REPOSITORY_MEMBER_PERMISSIONS,
        SET_REPOSITORY_MEMBER_PERMISSIONS,
        LIST_REPOSITORY_TEAM_PERMISSIONS,
        SET_REPOSITORY_TEAM_PERMISSIONS,
        LIST_FEDERATION_REGISTRATIONS,
        LIST_FEDERATION_RESULTS,
        LIST_FEDERATION_PROPOSALS,
        LIST_FEDERATION_SETS,
        EDIT_SETTINGS,
        LIST_STATUS;


        public static RpcRequest fromName(String name) {
            for (RpcRequest type : RpcRequest.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }

        public boolean exceeds(RpcRequest type) {
            return this.ordinal() > type.ordinal();
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum FederationProposalResult {
        ERROR,
        FEDERATION_DISABLED,
        MISSING_DATA,
        NO_PROPOSALS,
        NO_POKE,
        ACCEPTED;


        public String toString() {
            return this.name();
        }
    }

    public static enum FederationStrategy {
        EXCLUDE,
        FEDERATE_THIS,
        FEDERATE_ORIGIN;


        public static FederationStrategy fromName(String name) {
            for (FederationStrategy type : FederationStrategy.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return FEDERATE_THIS;
        }

        public boolean exceeds(FederationStrategy type) {
            return this.ordinal() > type.ordinal();
        }

        public boolean atLeast(FederationStrategy type) {
            return this.ordinal() >= type.ordinal();
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum FederationPullStatus {
        PENDING,
        FAILED,
        SKIPPED,
        PULLED,
        MIRRORED,
        NOCHANGE,
        EXCLUDED;


        public static FederationPullStatus fromName(String name) {
            for (FederationPullStatus type : FederationPullStatus.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return PENDING;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum FederationRequest {
        POKE,
        PROPOSAL,
        PULL_REPOSITORIES,
        PULL_USERS,
        PULL_TEAMS,
        PULL_SETTINGS,
        PULL_SCRIPTS,
        STATUS;


        public static FederationRequest fromName(String name) {
            for (FederationRequest type : FederationRequest.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return PULL_REPOSITORIES;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum FederationToken {
        ALL,
        USERS_AND_REPOSITORIES,
        REPOSITORIES;


        public static FederationToken fromName(String name) {
            for (FederationToken type : FederationToken.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return REPOSITORIES;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum AuthorizationControl {
        AUTHENTICATED,
        NAMED;


        public static AuthorizationControl fromName(String name) {
            for (AuthorizationControl type : AuthorizationControl.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return NAMED;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum AccessRestrictionType {
        NONE,
        PUSH,
        CLONE,
        VIEW;


        public static AccessRestrictionType fromName(String name) {
            for (AccessRestrictionType type : AccessRestrictionType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return NONE;
        }

        public boolean exceeds(AccessRestrictionType type) {
            return this.ordinal() > type.ordinal();
        }

        public boolean atLeast(AccessRestrictionType type) {
            return this.ordinal() >= type.ordinal();
        }

        public String toString() {
            return this.name();
        }
    }
}

