/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.AuthenticationFilter;
import com.gitblit.GitBlit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AccessRestrictionFilter
extends AuthenticationFilter {
    protected abstract String extractRepositoryName(String var1);

    protected abstract String getUrlRequestAction(String var1);

    protected abstract boolean isCreationAllowed();

    protected abstract boolean isActionAllowed(RepositoryModel var1, String var2);

    protected abstract boolean requiresAuthentication(RepositoryModel var1, String var2);

    protected abstract boolean canAccess(RepositoryModel var1, UserModel var2, String var3);

    protected RepositoryModel createRepository(UserModel user, String repository, String action) {
        return null;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String fullUrl = this.getFullUrl(httpRequest);
        String repository = this.extractRepositoryName(fullUrl);
        if (GitBlit.self().isCollectingGarbage(repository)) {
            this.logger.info(MessageFormat.format("ARF: Rejecting request for {0}, busy collecting garbage!", repository));
            httpResponse.sendError(403);
            return;
        }
        String fullSuffix = fullUrl.substring(repository.length());
        String urlRequestType = this.getUrlRequestAction(fullSuffix);
        UserModel user = this.getUser(httpRequest);
        RepositoryModel model = GitBlit.self().getRepositoryModel(repository);
        if (model == null) {
            if (this.isCreationAllowed()) {
                if (user == null) {
                    if (GitBlit.isDebugMode()) {
                        this.logger.info(MessageFormat.format("ARF: CREATE CHALLENGE {0}", fullUrl));
                    }
                    httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Gitblit\"");
                    httpResponse.sendError(401);
                    return;
                }
                model = this.createRepository(user, repository, urlRequestType);
            }
            if (model == null) {
                this.logger.info(MessageFormat.format("ARF: {0} ({1})", fullUrl, 404));
                httpResponse.sendError(404);
                return;
            }
        }
        if (!this.isActionAllowed(model, urlRequestType)) {
            this.logger.info(MessageFormat.format("ARF: action {0} on {1} forbidden ({2})", urlRequestType, model, 403));
            httpResponse.sendError(403);
            return;
        }
        AuthenticationFilter.AuthenticatedRequest authenticatedRequest = new AuthenticationFilter.AuthenticatedRequest(httpRequest);
        if (user != null) {
            authenticatedRequest.setUser(user);
        }
        if (!StringUtils.isEmpty(urlRequestType) && this.requiresAuthentication(model, urlRequestType)) {
            if (user == null) {
                if (GitBlit.isDebugMode()) {
                    this.logger.info(MessageFormat.format("ARF: CHALLENGE {0}", fullUrl));
                }
                httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Gitblit\"");
                httpResponse.sendError(401);
                return;
            }
            if (user.canAdmin() || this.canAccess(model, user, urlRequestType)) {
                this.newSession(authenticatedRequest, httpResponse);
                this.logger.info(MessageFormat.format("ARF: {0} ({1}) authenticated", fullUrl, 100));
                chain.doFilter((ServletRequest)authenticatedRequest, (ServletResponse)httpResponse);
                return;
            }
            if (GitBlit.isDebugMode()) {
                this.logger.info(MessageFormat.format("ARF: {0} forbidden to access {1}", user.username, fullUrl));
            }
            httpResponse.sendError(403);
            return;
        }
        if (GitBlit.isDebugMode()) {
            this.logger.info(MessageFormat.format("ARF: {0} ({1}) unauthenticated", fullUrl, 100));
        }
        chain.doFilter((ServletRequest)authenticatedRequest, (ServletResponse)httpResponse);
    }
}

