/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.security.ssl;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.wso2.andes.transport.ConnectionSettings;
import org.wso2.andes.transport.Sender;
import org.wso2.andes.transport.SenderException;
import org.wso2.andes.transport.network.security.ssl.SSLUtil;
import org.wso2.andes.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLSender
implements Sender<ByteBuffer> {
    private Sender<ByteBuffer> delegate;
    private SSLEngine engine;
    private int sslBufSize;
    private ByteBuffer netData;
    private long timeout = 30000L;
    private ConnectionSettings settings;
    private final Object engineState = new Object();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean error = new AtomicBoolean(false);
    private static final Logger log = Logger.get(SSLSender.class);

    public SSLSender(SSLEngine engine, Sender<ByteBuffer> delegate) {
        this.engine = engine;
        this.delegate = delegate;
        this.sslBufSize = engine.getSession().getPacketBufferSize();
        this.netData = ByteBuffer.allocate(this.sslBufSize);
        this.timeout = Long.getLong("qpid.ssl_timeout", 60000L);
    }

    public void setConnectionSettings(ConnectionSettings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.engine.isOutboundDone()) {
                return;
            }
            log.debug("Closing SSL connection", new Object[0]);
            this.engine.closeOutbound();
            try {
                this.tearDownSSLConnection();
            }
            catch (Exception e) {
                throw new SenderException("Error closing SSL connection", e);
            }
            Object object = this.engineState;
            synchronized (object) {
                while (!this.engine.isOutboundDone()) {
                    try {
                        this.engineState.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.delegate.close();
        }
    }

    private void tearDownSSLConnection() throws Exception {
        SSLEngineResult result = this.engine.wrap(ByteBuffer.allocate(0), this.netData);
        SSLEngineResult.Status status = result.getStatus();
        int read = result.bytesProduced();
        while (status != SSLEngineResult.Status.CLOSED) {
            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.netData.clear();
            }
            if (read > 0) {
                int limit = this.netData.limit();
                this.netData.limit(this.netData.position());
                this.netData.position(this.netData.position() - read);
                ByteBuffer data = this.netData.slice();
                this.netData.limit(limit);
                this.netData.position(this.netData.position() + read);
                this.delegate.send(data);
                this.flush();
            }
            result = this.engine.wrap(ByteBuffer.allocate(0), this.netData);
            status = result.getStatus();
            read = result.bytesProduced();
        }
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ByteBuffer appData) {
        if (this.closed.get()) {
            throw new SenderException("SSL Sender is closed");
        }
        block22: while (appData.hasRemaining() && !this.error.get()) {
            SSLEngineResult.HandshakeStatus handshakeStatus;
            SSLEngineResult.Status status;
            int read = 0;
            try {
                SSLEngineResult result = this.engine.wrap(appData, this.netData);
                read = result.bytesProduced();
                status = result.getStatus();
                handshakeStatus = result.getHandshakeStatus();
            }
            catch (SSLException e) {
                throw new SenderException("SSL, Error occurred while encrypting data", e);
            }
            if (read > 0) {
                int limit = this.netData.limit();
                this.netData.limit(this.netData.position());
                this.netData.position(this.netData.position() - read);
                ByteBuffer data = this.netData.slice();
                this.netData.limit(limit);
                this.netData.position(this.netData.position() + read);
                this.delegate.send(data);
            }
            switch (status) {
                case CLOSED: {
                    throw new SenderException("SSLEngine is closed");
                }
                case BUFFER_OVERFLOW: {
                    this.netData.clear();
                    continue block22;
                }
                case OK: {
                    break;
                }
                default: {
                    throw new IllegalStateException("SSLReceiver: Invalid State " + (Object)((Object)status));
                }
            }
            switch (handshakeStatus) {
                case NEED_WRAP: {
                    if (this.netData.hasRemaining()) continue block22;
                }
                case NEED_TASK: {
                    this.doTasks();
                    break;
                }
                case NEED_UNWRAP: {
                    this.flush();
                    Object object = this.engineState;
                    synchronized (object) {
                        switch (this.engine.getHandshakeStatus()) {
                            case NEED_UNWRAP: {
                                long start = System.currentTimeMillis();
                                try {
                                    this.engineState.wait(this.timeout);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                if (System.currentTimeMillis() - start < this.timeout) break;
                                throw new SenderException("SSL Engine timed out waiting for a response.To get more info,run with -Djavax.net.debug=ssl");
                            }
                        }
                        break;
                    }
                }
                case FINISHED: {
                    if (this.settings != null && this.settings.isVerifyHostname()) {
                        SSLUtil.verifyHostname(this.engine, this.settings.getHost());
                    }
                }
                case NOT_HANDSHAKING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("SSLSender: Invalid State " + (Object)((Object)status));
                }
            }
        }
    }

    public void doTasks() {
        Runnable runnable;
        while ((runnable = this.engine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    public Object getNotificationToken() {
        return this.engineState;
    }

    public void setErrorFlag() {
        this.error.set(true);
    }

    @Override
    public void setIdleTimeout(int i) {
        this.delegate.setIdleTimeout(i);
    }
}

