/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.Xid;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DtxStart
extends Method {
    public static final int TYPE = 1538;
    private short packing_flags = 0;
    private Xid xid;

    @Override
    public final int getStructType() {
        return 1538;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public DtxStart() {
    }

    public DtxStart(Xid xid, Option ... _options) {
        if (xid != null) {
            this.setXid(xid);
        }
        block8: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case JOIN: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block8;
                }
                case RESUME: {
                    this.packing_flags = (short)(this.packing_flags | 0x400);
                    continue block8;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block8;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block8;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block8;
                }
                case NONE: {
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.dtxStart(context, this);
    }

    public final boolean hasXid() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final DtxStart clearXid() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.xid = null;
        this.dirty = true;
        return this;
    }

    public final Xid getXid() {
        return this.xid;
    }

    public final DtxStart setXid(Xid value) {
        this.xid = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final DtxStart xid(Xid value) {
        return this.setXid(value);
    }

    public final boolean hasJoin() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final DtxStart clearJoin() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final boolean getJoin() {
        return this.hasJoin();
    }

    public final DtxStart setJoin(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final DtxStart join(boolean value) {
        return this.setJoin(value);
    }

    public final boolean hasResume() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final DtxStart clearResume() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final boolean getResume() {
        return this.hasResume();
    }

    public final DtxStart setResume(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x400) : (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final DtxStart resume(boolean value) {
        return this.setResume(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStruct(1540, this.xid);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.xid = (Xid)dec.readStruct(1540);
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("xid", this.getXid());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("join", this.getJoin());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("resume", this.getResume());
        }
        return result;
    }
}

