/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_91;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicConsumeBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_91.AMQMethodBody_0_91;
import org.wso2.andes.framing.amqp_0_91.MethodDispatcher_0_91;

public class BasicConsumeBodyImpl
extends AMQMethodBody_0_91
implements BasicConsumeBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new BasicConsumeBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 20;
    private final int _ticket;
    private final AMQShortString _queue;
    private final AMQShortString _consumerTag;
    private final byte _bitfield0;
    private final FieldTable _arguments;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public BasicConsumeBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._consumerTag = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._arguments = this.readFieldTable(buffer);
    }

    public BasicConsumeBodyImpl(int ticket, AMQShortString queue, AMQShortString consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, FieldTable arguments) {
        this._ticket = ticket;
        this._queue = queue;
        this._consumerTag = consumerTag;
        byte bitfield0 = 0;
        if (noLocal) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (noAck) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        this._bitfield0 = bitfield0;
        this._arguments = arguments;
    }

    public int getClazz() {
        return 60;
    }

    public int getMethod() {
        return 20;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    public final boolean getNoLocal() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getNoAck() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getExclusive() {
        return (this._bitfield0 & 4) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 8) != 0;
    }

    public final FieldTable getArguments() {
        return this._arguments;
    }

    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._queue);
        size += this.getSizeOf(this._consumerTag);
        return size += this.getSizeOf(this._arguments);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._arguments);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchBasicConsume(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicConsumeBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("noLocal=");
        buf.append(this.getNoLocal());
        buf.append(", ");
        buf.append("noAck=");
        buf.append(this.getNoAck());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }
}

