/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.andes.client.AMQAnyDestination;
import org.wso2.andes.client.AMQDestination;
import org.wso2.andes.client.AMQQueue;
import org.wso2.andes.client.AMQTopic;
import org.wso2.andes.client.message.AMQMessageDelegate;
import org.wso2.andes.client.message.ExchangeInfo;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.framing.AMQShortString;

public abstract class AbstractAMQMessageDelegate
implements AMQMessageDelegate {
    private static Map<String, Integer> _exchangeTypeToDestinationType = new ConcurrentHashMap<String, Integer>();
    private static Map<String, ExchangeInfo> _exchangeMap = new ConcurrentHashMap<String, ExchangeInfo>();

    protected AMQDestination generateDestination(AMQShortString exchange, AMQShortString routingKey) {
        ExchangeInfo exchangeInfo = _exchangeMap.get(exchange.asString());
        if (exchangeInfo == null) {
            exchangeInfo = new ExchangeInfo(exchange.asString(), "", 3);
        }
        AMQDestination dest = "topic".equals(exchangeInfo.exchangeType) ? new AMQTopic(exchange, routingKey, null) : ("direct".equals(exchangeInfo.exchangeType) ? new AMQQueue(exchange, routingKey, routingKey) : new AMQAnyDestination(exchange, new AMQShortString(exchangeInfo.exchangeType), routingKey, false, false, routingKey, false, new AMQShortString[]{routingKey}));
        return dest;
    }

    protected static void updateExchangeType(String exchange, String newtype) {
        Integer type = _exchangeTypeToDestinationType.get(newtype);
        if (type == null) {
            type = 3;
        }
        _exchangeMap.put(exchange, new ExchangeInfo(exchange, newtype, type));
    }

    protected static boolean exchangeMapContains(String exchange) {
        return _exchangeMap.containsKey(exchange);
    }

    static {
        _exchangeTypeToDestinationType.put("", 1);
        _exchangeTypeToDestinationType.put(ExchangeDefaults.DIRECT_EXCHANGE_CLASS.toString(), 1);
        _exchangeTypeToDestinationType.put(ExchangeDefaults.TOPIC_EXCHANGE_CLASS.toString(), 2);
        _exchangeTypeToDestinationType.put(ExchangeDefaults.FANOUT_EXCHANGE_CLASS.toString(), 2);
        _exchangeTypeToDestinationType.put(ExchangeDefaults.HEADERS_EXCHANGE_CLASS.toString(), 1);
        _exchangeMap.put("", new ExchangeInfo("", "", 1));
        _exchangeMap.put(ExchangeDefaults.DIRECT_EXCHANGE_NAME.toString(), new ExchangeInfo(ExchangeDefaults.DIRECT_EXCHANGE_NAME.toString(), ExchangeDefaults.DIRECT_EXCHANGE_CLASS.toString(), 1));
        _exchangeMap.put(ExchangeDefaults.TOPIC_EXCHANGE_NAME.toString(), new ExchangeInfo(ExchangeDefaults.TOPIC_EXCHANGE_NAME.toString(), ExchangeDefaults.TOPIC_EXCHANGE_CLASS.toString(), 2));
        _exchangeMap.put(ExchangeDefaults.FANOUT_EXCHANGE_NAME.toString(), new ExchangeInfo(ExchangeDefaults.FANOUT_EXCHANGE_NAME.toString(), ExchangeDefaults.FANOUT_EXCHANGE_CLASS.toString(), 2));
        _exchangeMap.put(ExchangeDefaults.HEADERS_EXCHANGE_NAME.toString(), new ExchangeInfo(ExchangeDefaults.HEADERS_EXCHANGE_NAME.toString(), ExchangeDefaults.HEADERS_EXCHANGE_CLASS.toString(), 1));
    }
}

