/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.lb.common.conf.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.lb.common.conf.util.TenantDomainContext;
import org.apache.synapse.SynapseException;
import sun.misc.BASE64Encoder;

public final class LoadBalancerConfigUtil {
    private static final Log log = LogFactory.getLog(LoadBalancerConfigUtil.class);

    private LoadBalancerConfigUtil() {
    }

    public static void handleException(String msg) {
        log.error((Object)msg);
        throw new RuntimeException(msg);
    }

    public static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    public static String replaceVariables(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = text.indexOf("${");
        if (indexOfStartingChars != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String var = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(var);
            if (propValue == null) {
                propValue = System.getenv(var);
            }
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
        }
        return text;
    }

    public static String getUserData(String payloadFileName) {
        String userData = null;
        try {
            byte[] bytes;
            File file = new File(payloadFileName);
            if (!file.exists()) {
                LoadBalancerConfigUtil.handleException("Payload file " + payloadFileName + " does not exist");
            }
            if (!file.canRead()) {
                LoadBalancerConfigUtil.handleException("Payload file " + payloadFileName + " does cannot be read");
            }
            if ((bytes = LoadBalancerConfigUtil.getBytesFromFile(file)) != null) {
                BASE64Encoder encoder = new BASE64Encoder();
                userData = encoder.encode(bytes);
            }
        }
        catch (Exception e) {
            LoadBalancerConfigUtil.handleException("Cannot read data from payload file " + payloadFileName, e);
        }
        return userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        byte[] bytes;
        if (!file.exists()) {
            log.error((Object)("Payload file " + file.getAbsolutePath() + " does not exist"));
            return null;
        }
        FileInputStream is = new FileInputStream(file);
        try {
            int offset;
            int numRead;
            long length = file.length();
            if (length > Integer.MAX_VALUE && log.isDebugEnabled()) {
                log.debug((Object)"File is too large");
            }
            bytes = new byte[(int)length];
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return bytes;
    }

    public static String getDomain(String str) {
        if (!(str = str.trim()).contains("#")) {
            return str;
        }
        return str.substring(str.indexOf("#") + 1);
    }

    public static String getSubDomain(String str) {
        if (!(str = str.trim()).contains("#")) {
            return null;
        }
        return str.substring(0, str.indexOf("#"));
    }

    public static List<TenantDomainContext> getTenantDomainContexts(String tenantRange, String domain, String subDomain) {
        ArrayList<TenantDomainContext> ctxts = new ArrayList<TenantDomainContext>();
        List<Integer> tenantIds = LoadBalancerConfigUtil.getTenantIds(tenantRange);
        for (Integer tId : tenantIds) {
            TenantDomainContext tenantCtxt = new TenantDomainContext(tId, domain, subDomain);
            ctxts.add(tenantCtxt);
        }
        return ctxts;
    }

    public static List<Integer> getTenantIds(String tenantRange) {
        ArrayList<Integer> tenantIds = new ArrayList<Integer>();
        String[] parsedLine = tenantRange.trim().split("-");
        if (parsedLine[0].equalsIgnoreCase("*")) {
            tenantIds.add(0);
        } else if (parsedLine.length == 1) {
            parsedLine = tenantRange.trim().split(",");
            if (parsedLine.length == 1) {
                try {
                    int tenantId = Integer.parseInt(tenantRange);
                    tenantIds.add(tenantId);
                }
                catch (NumberFormatException e) {
                    String msg = "Invalid tenant range is specified : " + tenantRange;
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
            } else {
                for (int i = 0; i < parsedLine.length; ++i) {
                    int tenantId = Integer.parseInt(parsedLine[i]);
                    tenantIds.add(tenantId);
                }
            }
        } else if (parsedLine.length == 2) {
            try {
                int startIndex = Integer.parseInt(parsedLine[0]);
                int endIndex = Integer.parseInt(parsedLine[1]);
                for (int tenantId = startIndex; tenantId <= endIndex; ++tenantId) {
                    tenantIds.add(tenantId);
                }
            }
            catch (NumberFormatException e) {
                String msg = "Invalid tenant range is specified : " + tenantRange;
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        } else {
            String msg = "Invalid tenant range is specified : " + tenantRange;
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return tenantIds;
    }
}

