/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.lb.common.conf.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.stratos.lb.common.conf.util.TenantDomainContext;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

public class HostContext {
    private String hostName;
    private Map<Integer, TenantDomainContext> tenantIdToTenantDomainContextMap = new HashMap<Integer, TenantDomainContext>();
    private AlgorithmContext algorithmContext;
    private LoadbalanceAlgorithm algorithm;
    private String urlSuffix;

    public HostContext(String hostName) {
        this.hostName = hostName;
    }

    public void addTenantDomainContexts(List<TenantDomainContext> ctxts) {
        for (TenantDomainContext tenantDomainContext : ctxts) {
            this.tenantIdToTenantDomainContextMap.put(tenantDomainContext.getTenantId(), tenantDomainContext);
        }
    }

    @Deprecated
    public void addTenantDomainContext(TenantDomainContext ctxt) {
        this.tenantIdToTenantDomainContextMap.put(ctxt.getTenantId(), ctxt);
    }

    public TenantDomainContext getTenantDomainContext(int tenantId) {
        return this.tenantIdToTenantDomainContextMap.get(tenantId);
    }

    public Collection<TenantDomainContext> getTenantDomainContexts() {
        return this.tenantIdToTenantDomainContextMap.values();
    }

    public String getDomainFromTenantId(int tenantId) {
        if (this.tenantIdToTenantDomainContextMap.get(tenantId) == null) {
            if (this.tenantIdToTenantDomainContextMap.get(0) == null) {
                return null;
            }
            return this.tenantIdToTenantDomainContextMap.get(0).getDomain();
        }
        return this.tenantIdToTenantDomainContextMap.get(tenantId).getDomain();
    }

    public String getSubDomainFromTenantId(int tenantId) {
        if (this.tenantIdToTenantDomainContextMap.get(tenantId) == null) {
            if (this.tenantIdToTenantDomainContextMap.get(0) == null) {
                return null;
            }
            return this.tenantIdToTenantDomainContextMap.get(0).getSubDomain();
        }
        return this.tenantIdToTenantDomainContextMap.get(tenantId).getSubDomain();
    }

    public String getHostName() {
        return this.hostName;
    }

    public LoadbalanceAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmContext getAlgorithmContext() {
        return this.algorithmContext;
    }

    public void setAlgorithmContext(AlgorithmContext algorithmContext) {
        this.algorithmContext = algorithmContext;
    }

    public void setAlgorithm(LoadbalanceAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Map<Integer, TenantDomainContext> getTenantIdToTenantDomainContextMap() {
        return this.tenantIdToTenantDomainContextMap;
    }

    public void setUrlSuffix(String suffix) {
        this.urlSuffix = suffix;
    }

    public String getUrlSuffix() {
        return this.urlSuffix;
    }
}

