/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.statistics.publisher;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.statistics.publisher.StatisticsPublisher;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.AsyncDataPublisher;
import org.wso2.carbon.databridge.agent.thrift.conf.AgentConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class WSO2CEPStatisticsPublisher
implements StatisticsPublisher {
    private static final Log log = LogFactory.getLog(WSO2CEPStatisticsPublisher.class);
    private StreamDefinition streamDefinition;
    private AsyncDataPublisher asyncDataPublisher;
    private String ip;
    private String port;
    private String username;
    private String password;
    private boolean enabled = false;

    public WSO2CEPStatisticsPublisher(StreamDefinition streamDefinition) {
        this.streamDefinition = streamDefinition;
        this.ip = System.getProperty("thrift.receiver.ip");
        this.port = System.getProperty("thrift.receiver.port");
        this.username = "admin";
        this.password = "admin";
        this.enabled = Boolean.getBoolean("cep.stats.publisher.enabled");
        if (this.enabled) {
            this.init();
        }
    }

    private void init() {
        AgentConfiguration agentConfiguration = new AgentConfiguration();
        Agent agent = new Agent(agentConfiguration);
        this.asyncDataPublisher = new AsyncDataPublisher("tcp://" + this.ip + ":" + this.port + "", this.username, this.password, agent);
        this.asyncDataPublisher.addStreamDefinition(this.streamDefinition);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.enabled) {
            this.init();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void publish(Object[] payload) {
        block4: {
            if (!this.isEnabled()) {
                throw new RuntimeException("Statistics publisher is not enabled");
            }
            Event event = new Event();
            event.setPayloadData(payload);
            event.setArbitraryDataMap(new HashMap());
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Publishing cep event: [stream] %s [version] %s", this.streamDefinition.getName(), this.streamDefinition.getVersion()));
                }
                this.asyncDataPublisher.publish(this.streamDefinition.getName(), this.streamDefinition.getVersion(), event);
            }
            catch (AgentException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)String.format("Could not publish cep event: [stream] %s [version] %s", this.streamDefinition.getName(), this.streamDefinition.getVersion()), (Throwable)e);
            }
        }
    }
}

