/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;

public class CartridgeAgentUtils {
    private static final Log log = LogFactory.getLog(CartridgeAgentUtils.class);

    public static List<String> splitUsingTokenizer(String string, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(string, delimiter);
        ArrayList<String> list = new ArrayList<String>(string.length());
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list;
    }

    public static String decryptPassword(String repoUserPassword) {
        if (repoUserPassword == null) {
            return repoUserPassword;
        }
        String decryptPassword = "";
        String secret = CartridgeAgentConfiguration.getInstance().getCartridgeKey();
        SecretKeySpec key = new SecretKeySpec(secret.getBytes(), "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding", "SunJCE");
            Base64 coder = new Base64();
            byte[] encrypted = coder.decode(repoUserPassword.getBytes());
            cipher.init(2, key);
            byte[] decrypted = cipher.doFinal(encrypted);
            decryptPassword = new String(decrypted);
        }
        catch (Exception e) {
            log.error((Object)("Exception has occurred. " + e.getMessage()));
            e.printStackTrace();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decrypted PWD : [" + decryptPassword + "] "));
        }
        return decryptPassword;
    }

    public static void waitUntilPortsActive(String ipAddress, List<Integer> ports) {
        long portCheckTimeOut = 600000L;
        String portCheckTimeOutStr = System.getProperty("port.check.timeout");
        if (StringUtils.isNotBlank((CharSequence)portCheckTimeOutStr)) {
            portCheckTimeOut = Integer.parseInt(portCheckTimeOutStr);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Port check timeout: " + portCheckTimeOut));
        }
        long startTime = System.currentTimeMillis();
        boolean active = false;
        while (!active) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Waiting for ports to be active: [IP] " + ipAddress + " [Ports] " + ports));
            }
            active = CartridgeAgentUtils.checkPortsActive(ipAddress, ports);
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            if (duration > portCheckTimeOut) {
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPortsActive(String ipAddress, List<Integer> ports) {
        if (ports.size() == 0) {
            throw new RuntimeException("No ports found");
        }
        for (int port : ports) {
            Socket socket = null;
            try {
                InetSocketAddress httpSockaddr = new InetSocketAddress(ipAddress, port);
                socket = new Socket();
                socket.connect(httpSockaddr, 5000);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Port %s is active", port));
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Port %s is not active", port));
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }
}

