/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.statistics.publisher;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.util.CartridgeAgentUtils;

public class HealthStatisticsReader {
    private static final int MB = 0x100000;
    private static final Log log = LogFactory.getLog(HealthStatisticsReader.class);

    public static double getMemoryConsumption() {
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double totalMemory = osBean.getTotalPhysicalMemorySize() / 0x100000L;
        double usedMemory = totalMemory - (double)(osBean.getFreePhysicalMemorySize() / 0x100000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculating memory consumption: [totalMemory] " + totalMemory + " [usedMemory] " + usedMemory));
        }
        double memoryConsumption = usedMemory / totalMemory * 100.0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculating memory consumption: [percentage] " + memoryConsumption));
        }
        return memoryConsumption;
    }

    public static double getLoadAverage() {
        double loadAvg = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        int cores = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculating load average consumption: [loadAverage] " + loadAvg + " [cores] " + cores));
        }
        double loadAvgPercentage = loadAvg / (double)cores * 100.0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculating load average consumption: [percentage] " + loadAvgPercentage));
        }
        return loadAvgPercentage;
    }

    public static boolean allPortsActive() {
        return CartridgeAgentUtils.checkPortsActive(CartridgeAgentConfiguration.getInstance().getListenAddress(), CartridgeAgentConfiguration.getInstance().getPorts());
    }
}

