/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.data.publisher;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.data.publisher.DataContext;
import org.apache.stratos.cartridge.agent.data.publisher.DataPublisherConfiguration;
import org.apache.stratos.cartridge.agent.data.publisher.GenericDataPublisher;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.AsyncDataPublisher;
import org.wso2.carbon.databridge.agent.thrift.conf.AgentConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public abstract class DataPublisher
implements GenericDataPublisher {
    private static final Log log = LogFactory.getLog(DataPublisher.class);
    private StreamDefinition streamDefinition;
    private DataPublisherConfiguration dataPublisherConfig;
    private AsyncDataPublisher dataPublisher;
    private boolean isDataPublisherInitialized;

    public DataPublisher(DataPublisherConfiguration dataPublisherConfig, StreamDefinition streamDefinition) {
        this.dataPublisherConfig = dataPublisherConfig;
        this.streamDefinition = streamDefinition;
        this.setDataPublisherInitialized(false);
    }

    @Override
    public void initialize() {
        AgentConfiguration agentConfiguration = new AgentConfiguration();
        Agent agent = new Agent(agentConfiguration);
        this.dataPublisher = new AsyncDataPublisher(this.dataPublisherConfig.getMonitoringServerUrl(), this.dataPublisherConfig.getAdminUsername(), this.dataPublisherConfig.getAdminPassword(), agent);
        if (!this.dataPublisher.isStreamDefinitionAdded(this.streamDefinition.getName(), this.streamDefinition.getVersion())) {
            this.dataPublisher.addStreamDefinition(this.streamDefinition);
        }
        this.setDataPublisherInitialized(true);
        log.info((Object)"DataPublisher initialized");
    }

    @Override
    public void publish(DataContext dataContext) {
        Event event = new Event();
        event.setTimeStamp(new Date().getTime());
        event.setMetaData(dataContext.getMetaData());
        event.setPayloadData(dataContext.getPayloadData());
        try {
            this.dataPublisher.publish(this.streamDefinition.getName(), this.streamDefinition.getVersion(), event);
        }
        catch (AgentException e) {
            String errorMsg = "Error in publishing event";
            log.error((Object)errorMsg, (Throwable)e);
        }
    }

    @Override
    public void terminate() {
        this.dataPublisher.stop();
    }

    public boolean isDataPublisherInitialized() {
        return this.isDataPublisherInitialized;
    }

    public void setDataPublisherInitialized(boolean dataPublisherInitialized) {
        this.isDataPublisherInitialized = dataPublisherInitialized;
    }
}

