/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.exception.ParameterNotFoundException;
import org.apache.stratos.cartridge.agent.util.CartridgeAgentUtils;

public class CartridgeAgentConfiguration {
    private static final Log log = LogFactory.getLog(CartridgeAgentConfiguration.class);
    private static volatile CartridgeAgentConfiguration instance;
    private final String serviceName;
    private final String clusterId;
    private final String networkPartitionId;
    private final String partitionId;
    private final String memberId;
    private final String cartridgeKey;
    private final String appPath;
    private final String repoUrl;
    private final List<Integer> ports;
    private final List<String> logFilePaths;
    private Map<String, String> parameters = this.loadParametersFile();
    private boolean isMultitenant;
    private String persistenceMappings;
    private final boolean isCommitsEnabled;
    private final String listenAddress;

    private CartridgeAgentConfiguration() {
        try {
            this.serviceName = this.readParameterValue("SERVICE_NAME");
            this.clusterId = this.readParameterValue("CLUSTER_ID");
            this.networkPartitionId = this.readParameterValue("NETWORK_PARTITION_ID");
            this.partitionId = this.readParameterValue("PARTITION_ID");
            this.memberId = this.readParameterValue("MEMBER_ID");
            this.cartridgeKey = this.readParameterValue("CARTRIDGE_KEY");
            this.appPath = this.readParameterValue("APP_PATH");
            this.repoUrl = this.readParameterValue("REPO_URL");
            this.ports = this.readPorts();
            this.logFilePaths = this.readLogFilePaths();
            this.isMultitenant = this.readMultitenant("MULTITENANT");
            this.persistenceMappings = this.readPersisenceMapping();
            this.isCommitsEnabled = this.readCommitsEnabled("COMMIT_ENABLED");
            this.listenAddress = System.getProperty("listen.address");
        }
        catch (ParameterNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Cartridge agent configuration initialized");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("service-name: %s", this.serviceName));
            log.debug((Object)String.format("cluster-id: %s", this.clusterId));
            log.debug((Object)String.format("network-partition-id: %s", this.networkPartitionId));
            log.debug((Object)String.format("partition-id: %s", this.partitionId));
            log.debug((Object)String.format("member-id: %s", this.memberId));
            log.debug((Object)String.format("cartridge-key: %s", this.cartridgeKey));
            log.debug((Object)String.format("app-path: %s", this.appPath));
            log.debug((Object)String.format("repo-url: %s", this.repoUrl));
            log.debug((Object)String.format("ports: %s", this.ports.toString()));
        }
    }

    private boolean readCommitsEnabled(String commitEnabled) {
        boolean isCommitEnabled = false;
        try {
            isCommitEnabled = Boolean.parseBoolean(this.readParameterValue(commitEnabled));
        }
        catch (ParameterNotFoundException e) {
            log.error((Object)" Commits enabled payload parameter is not found");
        }
        return isCommitEnabled;
    }

    private boolean readMultitenant(String multitenant) throws ParameterNotFoundException {
        String multitenantStringValue = this.readParameterValue(multitenant);
        return Boolean.parseBoolean(multitenantStringValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CartridgeAgentConfiguration getInstance() {
        if (instance != null) return instance;
        Class<CartridgeAgentConfiguration> clazz = CartridgeAgentConfiguration.class;
        synchronized (CartridgeAgentConfiguration.class) {
            if (instance != null) return instance;
            instance = new CartridgeAgentConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private String readPersisenceMapping() {
        String persistenceMapping;
        block3: {
            persistenceMapping = null;
            try {
                persistenceMapping = this.readParameterValue("PERSISTENCE_MAPPING");
            }
            catch (ParameterNotFoundException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Cannot read persistence mapping : " + e.getMessage()));
            }
        }
        if (persistenceMapping == null || persistenceMapping.isEmpty()) {
            return null;
        }
        return persistenceMapping;
    }

    private Map<String, String> loadParametersFile() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            File file = new File(System.getProperty("param.file.path"));
            if (!file.exists()) {
                log.warn((Object)String.format("File not found: %s", "param.file.path"));
                return parameters;
            }
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                String[] params;
                String line = scanner.nextLine();
                for (String string : params = line.split(",")) {
                    String[] var;
                    if (string == null || (var = string.split("=")).length < 2) continue;
                    parameters.put(var[0], var[1]);
                }
            }
            scanner.close();
        }
        catch (Exception e) {
            String message = "Could not read launch parameter file, hence trying to read from System properties.";
            log.warn((Object)message, (Throwable)e);
        }
        return parameters;
    }

    private String readParameterValue(String parameterName) throws ParameterNotFoundException {
        if (this.parameters.containsKey(parameterName)) {
            return this.parameters.get(parameterName);
        }
        if (System.getProperty(parameterName) != null) {
            return System.getProperty(parameterName);
        }
        String message = "Cannot find the value of required parameter: " + parameterName;
        throw new ParameterNotFoundException(message);
    }

    private List<Integer> readPorts() throws ParameterNotFoundException {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        String portsStr = this.readParameterValue("PORTS");
        List<String> portsStrList = CartridgeAgentUtils.splitUsingTokenizer(portsStr, "|");
        for (String port : portsStrList) {
            ports.add(Integer.parseInt(port));
        }
        return ports;
    }

    private List<String> readLogFilePaths() {
        String logFileStr;
        block3: {
            logFileStr = null;
            try {
                logFileStr = this.readParameterValue("LOG_FILE_PATHS");
            }
            catch (ParameterNotFoundException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Cannot read log file path : " + e.getMessage()));
            }
        }
        if (logFileStr == null || logFileStr.isEmpty()) {
            return null;
        }
        return CartridgeAgentUtils.splitUsingTokenizer(logFileStr.trim(), "|");
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getNetworkPartitionId() {
        return this.networkPartitionId;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getCartridgeKey() {
        return this.cartridgeKey;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public List<String> getLogFilePaths() {
        return this.logFilePaths;
    }

    public boolean isMultitenant() {
        return this.isMultitenant;
    }

    public String getPersistenceMappings() {
        return this.persistenceMappings;
    }

    public boolean isCommitsEnabled() {
        return this.isCommitsEnabled;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }
}

