/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.impl;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.RepositoryInformation;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.internal.CustomJschConfigSessionFactory;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.internal.RepositoryContext;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.util.Utilities;
import org.apache.stratos.cartridge.agent.util.ExtensionUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitBasedArtifactRepository {
    private static final int SUPER_TENANT_ID = -1234;
    private static final Log log = LogFactory.getLog(GitBasedArtifactRepository.class);
    private static ConcurrentHashMap<Integer, RepositoryContext> tenantToRepoContextMap = new ConcurrentHashMap();
    private static volatile GitBasedArtifactRepository gitBasedArtifactRepository;
    private static String SUPER_TENANT_APP_PATH;
    private static String TENANT_PATH;

    private GitBasedArtifactRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GitBasedArtifactRepository getInstance() {
        if (gitBasedArtifactRepository != null) return gitBasedArtifactRepository;
        Class<GitBasedArtifactRepository> clazz = GitBasedArtifactRepository.class;
        synchronized (GitBasedArtifactRepository.class) {
            if (gitBasedArtifactRepository != null) return gitBasedArtifactRepository;
            gitBasedArtifactRepository = new GitBasedArtifactRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gitBasedArtifactRepository;
        }
    }

    private void initGitContext(RepositoryInformation repositoryInformation) {
        log.info((Object)"Initializing git context.");
        int tenantId = Integer.parseInt(repositoryInformation.getTenantId());
        String gitLocalRepoPath = repositoryInformation.getRepoPath();
        RepositoryContext gitRepoCtx = new RepositoryContext();
        String gitRemoteRepoUrl = repositoryInformation.getRepoUrl();
        boolean isMultitenant = repositoryInformation.isMultitenant();
        log.info((Object)("local path " + gitLocalRepoPath));
        log.info((Object)("remote url " + gitRemoteRepoUrl));
        log.info((Object)("tenant " + tenantId));
        gitRepoCtx.setTenantId(tenantId);
        gitRepoCtx.setGitLocalRepoPath(GitBasedArtifactRepository.getRepoPathForTenantId(tenantId, gitLocalRepoPath, isMultitenant));
        gitRepoCtx.setGitRemoteRepoUrl(gitRemoteRepoUrl);
        gitRepoCtx.setRepoUsername(repositoryInformation.getRepoUsername());
        gitRepoCtx.setRepoPassword(repositoryInformation.getRepoPassword());
        try {
            if (this.isKeyBasedAuthentication(gitRemoteRepoUrl, tenantId)) {
                gitRepoCtx.setKeyBasedAuthentication(true);
                this.initSSHAuthentication();
            } else {
                gitRepoCtx.setKeyBasedAuthentication(false);
            }
        }
        catch (Exception e1) {
            log.error((Object)("Exception occurred.. " + e1.getMessage()), (Throwable)e1);
        }
        FileRepository localRepo = null;
        try {
            localRepo = new FileRepository(new File(gitRepoCtx.getGitLocalRepoPath() + "/.git"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        gitRepoCtx.setLocalRepo((Repository)localRepo);
        gitRepoCtx.setGit(new Git(localRepo));
        gitRepoCtx.setCloneExists(false);
        this.cacheGitRepoContext(tenantId, gitRepoCtx);
    }

    private static String getRepoPathForTenantId(int tenantId, String gitLocalRepoPath, boolean isMultitenant) {
        StringBuilder repoPathBuilder = new StringBuilder();
        String repoPath = null;
        if (isMultitenant) {
            if (tenantId == -1234) {
                repoPathBuilder.append(gitLocalRepoPath).append(SUPER_TENANT_APP_PATH);
            } else {
                GitBasedArtifactRepository.createTenantDir(tenantId, gitLocalRepoPath);
                repoPathBuilder.append(gitLocalRepoPath).append(TENANT_PATH).append(tenantId);
            }
            repoPath = repoPathBuilder.toString();
        } else {
            repoPath = gitLocalRepoPath;
        }
        log.info((Object)("Repo path returned : " + repoPath));
        return repoPath;
    }

    private static void createTenantDir(int tenantId, String path) {
        String dirPathName = path + TENANT_PATH + tenantId;
        boolean dirStatus = new File(dirPathName).mkdir();
        if (dirStatus) {
            log.info((Object)("Successfully created directory [" + dirPathName + "] "));
        } else {
            log.error((Object)("Directory creating failed in [" + dirPathName + "] "));
        }
    }

    private boolean isKeyBasedAuthentication(String url, int tenantId) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return false;
        }
        if (url.startsWith("git://github.com")) {
            return false;
        }
        if (url.startsWith("ssh://") || url.contains("@")) {
            return true;
        }
        log.error((Object)("Invalid git URL provided for tenant " + tenantId));
        throw new RuntimeException("Invalid git URL provided for tenant " + tenantId);
    }

    private void initSSHAuthentication() {
        SshSessionFactory.setInstance((SshSessionFactory)new CustomJschConfigSessionFactory());
    }

    private void cacheGitRepoContext(int tenantId, RepositoryContext gitRepoCtx) {
        log.info((Object)"caching repo context");
        tenantToRepoContextMap.put(tenantId, gitRepoCtx);
    }

    private RepositoryContext retrieveCachedGitContext(int tenantId) {
        return tenantToRepoContextMap.get(tenantId);
    }

    public boolean commit() {
        Iterator<Map.Entry<Integer, RepositoryContext>> i$ = tenantToRepoContextMap.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<Integer, RepositoryContext> tenantMap = i$.next();
            int tenantId = tenantMap.getKey();
            RepositoryContext gitRepoCtx = this.retrieveCachedGitContext(tenantId);
            if (gitRepoCtx == null) {
                log.info((Object)("No git repository context information found for tenant " + tenantId));
                return false;
            }
            Git git = gitRepoCtx.getGit();
            StatusCommand statusCmd = git.status();
            Status status = null;
            try {
                status = statusCmd.call();
            }
            catch (GitAPIException e) {
                log.error((Object)("Git status operation for tenant " + gitRepoCtx.getTenantId() + " failed, "), (Throwable)e);
                return false;
            }
            if (status.isClean()) {
                log.debug((Object)("No changes detected in the local repository for tenant " + tenantId));
                return false;
            }
            this.addArtifacts(gitRepoCtx, this.getNewArtifacts(status));
            this.addArtifacts(gitRepoCtx, this.getModifiedArtifacts(status));
            this.removeArtifacts(gitRepoCtx, this.getRemovedArtifacts(status));
            this.commitToLocalRepo(gitRepoCtx);
            this.pushToRemoteRepo(gitRepoCtx);
            return false;
        }
        return false;
    }

    private Set<String> getNewArtifacts(Status status) {
        return status.getUntracked();
    }

    private Set<String> getRemovedArtifacts(Status status) {
        return status.getMissing();
    }

    private Set<String> getModifiedArtifacts(Status status) {
        return status.getModified();
    }

    private void addArtifacts(RepositoryContext gitRepoCtx, Set<String> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        AddCommand addCmd = gitRepoCtx.getGit().add();
        Iterator<String> it = artifacts.iterator();
        while (it.hasNext()) {
            addCmd.addFilepattern(it.next());
        }
        try {
            addCmd.call();
        }
        catch (GitAPIException e) {
            log.error((Object)("Adding artifact to the local repository at " + gitRepoCtx.getGitLocalRepoPath() + "failed"), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void removeArtifacts(RepositoryContext gitRepoCtx, Set<String> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        RmCommand rmCmd = gitRepoCtx.getGit().rm();
        Iterator<String> it = artifacts.iterator();
        while (it.hasNext()) {
            rmCmd.addFilepattern(it.next());
        }
        try {
            rmCmd.call();
        }
        catch (GitAPIException e) {
            log.error((Object)("Removing artifact from the local repository at " + gitRepoCtx.getGitLocalRepoPath() + "failed"), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void commitToLocalRepo(RepositoryContext gitRepoCtx) {
        CommitCommand commitCmd = gitRepoCtx.getGit().commit();
        commitCmd.setMessage("tenant " + gitRepoCtx.getTenantId() + "'s artifacts committed to local repo at " + gitRepoCtx.getGitLocalRepoPath());
        try {
            commitCmd.call();
        }
        catch (GitAPIException e) {
            log.error((Object)("Committing artifacts to local repository failed for tenant " + gitRepoCtx.getTenantId()), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void pushToRemoteRepo(RepositoryContext gitRepoCtx) {
        UsernamePasswordCredentialsProvider credentialsProvider;
        PushCommand pushCmd = gitRepoCtx.getGit().push();
        if (!gitRepoCtx.getKeyBasedAuthentication() && (credentialsProvider = GitBasedArtifactRepository.createCredentialsProvider(gitRepoCtx)) != null) {
            pushCmd.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        try {
            pushCmd.call();
        }
        catch (GitAPIException e) {
            log.error((Object)("Pushing artifacts to remote repository failed for tenant " + gitRepoCtx.getTenantId()), (Throwable)e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(RepositoryInformation repositoryInformation) {
        RepositoryContext gitRepoCtx;
        int tenantId;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Artifact checkout done by thread " + Thread.currentThread().getName() + " - " + Thread.currentThread().getId()));
        }
        if (tenantToRepoContextMap.get(tenantId = Integer.parseInt(repositoryInformation.getTenantId())) == null) {
            this.initGitContext(repositoryInformation);
        }
        if ((gitRepoCtx = this.retrieveCachedGitContext(tenantId)) == null) {
            log.info((Object)"No git repository context information found for deployment synchronizer");
            return true;
        }
        RepositoryContext repositoryContext = gitRepoCtx;
        synchronized (repositoryContext) {
            if (!gitRepoCtx.cloneExists()) {
                GitBasedArtifactRepository.cloneRepository(gitRepoCtx);
            }
            return this.pullArtifacts(gitRepoCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSyncTask(RepositoryInformation repoInformation, long delay) {
        int tenantId = Integer.parseInt(repoInformation.getTenantId());
        RepositoryContext repoCtxt = tenantToRepoContextMap.get(tenantId);
        if (repoCtxt == null) {
            log.error((Object)("Unable to schedule artifact sync task, repositoryContext null for tenant " + tenantId));
            return;
        }
        if (repoCtxt.getArtifactSyncSchedular() == null) {
            RepositoryContext repositoryContext = repoCtxt;
            synchronized (repositoryContext) {
                if (repoCtxt.getArtifactSyncSchedular() == null) {
                    ScheduledExecutorService artifactSyncScheduler = Executors.newScheduledThreadPool(1, new ArtifactSyncTaskThreadFactory(repoCtxt.getGitLocalRepoPath()));
                    artifactSyncScheduler.scheduleAtFixedRate(new ArtifactSyncTask(repoInformation), delay, delay, TimeUnit.SECONDS);
                    repoCtxt.setArtifactSyncSchedular(artifactSyncScheduler);
                    log.info((Object)("Scheduled Artifact Synchronization Task for path " + repoCtxt.getGitLocalRepoPath()));
                } else {
                    log.info((Object)("Artifact Synchronization Task for path " + repoCtxt.getGitLocalRepoPath() + " already scheduled"));
                }
            }
        }
    }

    public boolean cloneExists(RepositoryInformation repositoryInformation) {
        RepositoryContext gitRepoCtx;
        int tenantId = Integer.parseInt(repositoryInformation.getTenantId());
        if (tenantToRepoContextMap.get(tenantId) == null) {
            this.initGitContext(repositoryInformation);
        }
        if ((gitRepoCtx = this.retrieveCachedGitContext(tenantId)) == null) {
            return false;
        }
        return gitRepoCtx.cloneExists();
    }

    private boolean pullArtifacts(RepositoryContext gitRepoCtx) {
        UsernamePasswordCredentialsProvider credentialsProvider;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pulling artifacts");
        }
        PullCommand pullCmd = gitRepoCtx.getGit().pull();
        if (!gitRepoCtx.getKeyBasedAuthentication() && (credentialsProvider = GitBasedArtifactRepository.createCredentialsProvider(gitRepoCtx)) != null) {
            pullCmd.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        try {
            PullResult pullResult = pullCmd.call();
            if (!pullResult.getFetchResult().getTrackingRefUpdates().isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Artifacts were updated as a result of the pull operation, thread: " + Thread.currentThread().getName() + " - " + Thread.currentThread().getId()));
                }
                ExtensionUtils.executeArtifactsUpdatedExtension();
            }
        }
        catch (InvalidConfigurationException e) {
            log.warn((Object)("Git pull unsuccessful for tenant " + gitRepoCtx.getTenantId() + ", " + e.getMessage()));
            Utilities.deleteFolderStructure(new File(gitRepoCtx.getGitLocalRepoPath()));
            GitBasedArtifactRepository.cloneRepository(gitRepoCtx);
            ExtensionUtils.executeArtifactsUpdatedExtension();
            return true;
        }
        catch (JGitInternalException e) {
            log.warn((Object)("Git pull unsuccessful for tenant " + gitRepoCtx.getTenantId() + ", " + e.getMessage()));
            return false;
        }
        catch (TransportException e) {
            log.error((Object)("Accessing remote git repository " + gitRepoCtx.getGitRemoteRepoUrl() + " failed for tenant " + gitRepoCtx.getTenantId()), (Throwable)e);
            e.printStackTrace();
            return false;
        }
        catch (CheckoutConflictException e) {
            log.warn((Object)("Git pull for the path " + e.getConflictingPaths().toString() + " failed due to conflicts"));
            Utilities.deleteFolderStructure(new File(gitRepoCtx.getGitLocalRepoPath()));
            GitBasedArtifactRepository.cloneRepository(gitRepoCtx);
            ExtensionUtils.executeArtifactsUpdatedExtension();
            return true;
        }
        catch (GitAPIException e) {
            log.error((Object)("Git pull operation for tenant " + gitRepoCtx.getTenantId() + " failed"), (Throwable)e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void handleInvalidConfigurationError(RepositoryContext gitRepoCtx) {
        StoredConfig storedConfig = gitRepoCtx.getLocalRepo().getConfig();
        boolean modifiedConfig = false;
        if (storedConfig != null) {
            if (storedConfig.getString("branch", "master", "remote") == null || storedConfig.getString("branch", "master", "remote").isEmpty()) {
                storedConfig.setString("branch", "master", "remote", "origin");
                modifiedConfig = true;
            }
            if (storedConfig.getString("branch", "master", "merge") == null || storedConfig.getString("branch", "master", "merge").isEmpty()) {
                storedConfig.setString("branch", "master", "merge", "refs/heads/master");
                modifiedConfig = true;
            }
            if (modifiedConfig) {
                try {
                    storedConfig.save();
                }
                catch (IOException e) {
                    log.error((Object)("Error saving git configuration file in local repo at " + gitRepoCtx.getGitLocalRepoPath()), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }

    private static void cloneRepository(RepositoryContext gitRepoCtx) {
        UsernamePasswordCredentialsProvider credentialsProvider;
        File gitRepoDir = new File(gitRepoCtx.getGitLocalRepoPath());
        if (gitRepoDir.exists()) {
            if (GitBasedArtifactRepository.isValidGitRepo(gitRepoCtx)) {
                log.info((Object)("Existing git repository detected for tenant " + gitRepoCtx.getTenantId() + ", no clone required"));
                gitRepoCtx.setCloneExists(true);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Repository for tenant " + gitRepoCtx.getTenantId() + " is not a valid git repo"));
            }
            Utilities.deleteFolderStructure(gitRepoDir);
        }
        gitRepoCtx.getGit();
        CloneCommand cloneCmd = Git.cloneRepository().setURI(gitRepoCtx.getGitRemoteRepoUrl()).setDirectory(gitRepoDir);
        if (!gitRepoCtx.getKeyBasedAuthentication() && (credentialsProvider = GitBasedArtifactRepository.createCredentialsProvider(gitRepoCtx)) != null) {
            cloneCmd.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        try {
            cloneCmd.call();
            log.info((Object)("Git clone operation for tenant " + gitRepoCtx.getTenantId() + " successful"));
            gitRepoCtx.setCloneExists(true);
        }
        catch (TransportException e) {
            log.error((Object)("Accessing remote git repository failed for tenant " + gitRepoCtx.getTenantId()), (Throwable)e);
            e.printStackTrace();
        }
        catch (GitAPIException e) {
            log.error((Object)("Git clone operation for tenant " + gitRepoCtx.getTenantId() + " failed"), (Throwable)e);
            e.printStackTrace();
        }
    }

    private static UsernamePasswordCredentialsProvider createCredentialsProvider(RepositoryContext gitRepoCtx) {
        return new UsernamePasswordCredentialsProvider(gitRepoCtx.getRepoUsername(), gitRepoCtx.getRepoPassword());
    }

    private static boolean isValidGitRepo(RepositoryContext gitRepoCtx) {
        for (Ref ref : gitRepoCtx.getLocalRepo().getAllRefs().values()) {
            if (ref.getObjectId() == null) continue;
            return true;
        }
        return false;
    }

    public void cleanupAutoCheckout() {
    }

    public String getRepositoryType() {
        return null;
    }

    static {
        SUPER_TENANT_APP_PATH = "/repository/deployment/server/";
        TENANT_PATH = "/repository/tenants/";
    }

    class ArtifactSyncTaskThreadFactory
    implements ThreadFactory {
        private String localRepoPath;

        public ArtifactSyncTaskThreadFactory(String localRepoPath) {
            this.localRepoPath = localRepoPath;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Artifact Update Thread - " + this.localRepoPath);
        }
    }

    private class ArtifactSyncTask
    implements Runnable {
        private RepositoryInformation repositoryInformation;

        public ArtifactSyncTask(RepositoryInformation repositoryInformation) {
            this.repositoryInformation = repositoryInformation;
        }

        @Override
        public void run() {
            GitBasedArtifactRepository.this.checkout(this.repositoryInformation);
        }
    }
}

