/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.apache.stratos.cartridge.agent.CartridgeAgent;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.config.configurator.JndiConfigurator;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;

public class Main {
    private static final Log log = LogFactory.getLog(Main.class);
    private static CartridgeAgent cartridgeAgent = null;

    public static void main(String[] args) {
        block9: {
            try {
                final Thread mainThread = Thread.currentThread();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            EventPublisherPool.close((String)"instance-status");
                            mainThread.join();
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                });
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Configuring log4j.properties file path");
                }
                PropertyConfigurator.configure((String)System.getProperty("log4j.properties.file.path"));
                JndiConfigurator.configure();
                CartridgeAgentConfiguration.getInstance();
                if (args.length >= 1) {
                    String className = args[0];
                    try {
                        Constructor<?> c = Class.forName(className).getConstructor(new Class[0]);
                        cartridgeAgent = (CartridgeAgent)c.newInstance(new Object[0]);
                        log.info((Object)("Loaded Cartridge Agent using [class] " + className));
                    }
                    catch (Exception e) {
                        String msg = String.format("Cannot load Cartridge Agent from [class name] %s, hence using the default agent.", className);
                        log.warn((Object)msg, (Throwable)e);
                    }
                }
                if (cartridgeAgent == null) {
                    cartridgeAgent = new CartridgeAgent();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Loading default Cartridge Agent.");
                    }
                }
                Thread thread = new Thread(cartridgeAgent);
                thread.start();
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                if (cartridgeAgent == null) break block9;
                cartridgeAgent.terminate();
            }
        }
    }
}

