/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.registrant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.ClusteringClient;
import org.apache.stratos.cartridge.agent.exception.CartridgeAgentException;
import org.apache.stratos.cartridge.agent.registrant.PortMapping;
import org.apache.stratos.cartridge.agent.registrant.Registrant;
import org.apache.stratos.cartridge.agent.registrant.RegistrantDatabase;

public class RegistrantUtil {
    private static final Log log = LogFactory.getLog(RegistrantUtil.class);
    private static boolean registrantsReloaded = false;

    public static boolean isHealthy(Registrant registrant) {
        int maxRetries;
        InetAddress addr;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to connect to registrant " + registrant + "..."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("***********************************************isHealthy() method for registrant " + registrant));
        }
        String registrantRemoteHost = registrant.getRemoteHost();
        log.debug((Object)("remote host : " + registrantRemoteHost));
        if (registrantRemoteHost == null) {
            registrantRemoteHost = "localhost";
        }
        try {
            addr = InetAddress.getByName(registrantRemoteHost);
            if (log.isDebugEnabled()) {
                log.debug((Object)("***********************************************Host resolved for registrant " + registrant));
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)("Registrant " + registrant + " is unhealthy"));
            return false;
        }
        PortMapping[] portMappings = registrant.getPortMappings();
        for (int retries = maxRetries = Integer.parseInt(System.getProperty("clustering.maxRetries")); retries > 0; --retries) {
            try {
                for (PortMapping portMapping : portMappings) {
                    int port = portMapping.getPrimaryPort();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("***********************************************primary port" + port + " registrant " + registrant));
                    }
                    if (port == -1 || port == 0) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("***********************************************connecting to " + registrant + " re-try: " + retries));
                    }
                    InetSocketAddress httpSockaddr = new InetSocketAddress(addr, port);
                    new Socket().connect(httpSockaddr, 10000);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("***********************************************connected successfully to port: " + port));
                }
                return true;
            }
            catch (IOException e) {
                String msg;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error occurred.. " + e.getMessage()));
                }
                if (!(msg = e.getMessage()).contains("Connection refused") && !msg.contains("connect timed out")) {
                    String msg2 = "Cannot connect to registrant " + registrant;
                    log.error((Object)msg2, (Throwable)e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    public static void reloadRegistrants(ClusteringClient clusteringClient, ConfigurationContext configurationContext, RegistrantDatabase registrantDatabase) throws CartridgeAgentException {
        if (registrantsReloaded) {
            log.info((Object)"Registrants already re-loaded, therefore not re-loading again");
            return;
        }
        File registrants = new File("registrants");
        if (!registrants.exists()) {
            log.info((Object)"Registrant information doesn't exist in the file system");
            return;
        }
        File[] files = registrants.listFiles();
        if (files == null) {
            log.error((Object)"Directory 'Registrants' is invalid");
            return;
        }
        if (files.length == 0) {
            log.info((Object)"No registrant information found in the Registrants directory");
            return;
        }
        for (File file : files) {
            try {
                Registrant registrant = RegistrantUtil.deserializeRegistrant("registrants" + File.separator + file.getName());
                if (registrantDatabase.containsActive(registrant)) continue;
                clusteringClient.joinGroup(registrant, configurationContext);
            }
            catch (IOException e) {
                log.error((Object)("Cannot deserialize registrant file " + file.getName()), (Throwable)e);
            }
        }
        registrantsReloaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Registrant deserializeRegistrant(String fileName) throws IOException {
        Registrant registrant = null;
        ObjectInputStream in = null;
        try {
            File file = new File(fileName);
            in = new ObjectInputStream(new FileInputStream(file));
            registrant = (Registrant)in.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return registrant;
    }
}

