/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.adc.instanceinfo.mgt.stub.InstanceInformationManagementServiceStub;
import org.apache.stratos.cartridge.agent.registrant.Registrant;

public class InstanceStateNotificationClientThread
implements Runnable {
    private Registrant registrant;
    private String state;
    private static final Log log = LogFactory.getLog(InstanceStateNotificationClientThread.class);

    public InstanceStateNotificationClientThread(Registrant registrant, String state) {
        this.registrant = registrant;
        this.state = state;
    }

    @Override
    public void run() {
        try {
            log.info((Object)("Instance State is updated to " + this.state + " " + this.registrant.getRemoteHost()));
            String serviceURL = "https://" + System.getProperty("adc.host") + ":" + System.getProperty("adc.port") + "/services/InstanceInformationManagementService";
            InstanceInformationManagementServiceStub stub = new InstanceInformationManagementServiceStub(serviceURL);
            stub.updateInstanceState(this.registrant.getRemoteHost(), 123, this.registrant.retrieveClusterDomain(), "__$default", this.registrant.getService(), this.state);
        }
        catch (AxisFault e) {
            log.warn((Object)("Error notifying state " + this.state + " of registrant " + this.registrant + " to ADC"), (Throwable)e);
        }
        catch (RemoteException e) {
            log.warn((Object)("Error notifying state " + this.state + " of registrant " + this.registrant + " to ADC"), (Throwable)e);
        }
    }
}

