/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent;

import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.MembershipListener;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.ClusteringClient;
import org.apache.stratos.cartridge.agent.exception.CartridgeAgentException;
import org.apache.stratos.cartridge.agent.registrant.RegistrantDatabase;
import org.apache.stratos.cartridge.agent.registrant.RegistrantHealthChecker;
import org.apache.stratos.cartridge.agent.registrant.RegistrantUtil;

public class ELBMembershipListener
implements MembershipListener {
    private static final Log log = LogFactory.getLog(ELBMembershipListener.class);
    private ClusteringClient clusteringClient;
    private ConfigurationContext configurationContext;
    private RegistrantDatabase registrantDatabase;
    private RegistrantHealthChecker healthChecker;

    public ELBMembershipListener(ClusteringClient clusteringClient, ConfigurationContext configurationContext, RegistrantDatabase registrantDatabase, RegistrantHealthChecker healthChecker) {
        this.clusteringClient = clusteringClient;
        this.configurationContext = configurationContext;
        this.registrantDatabase = registrantDatabase;
        this.healthChecker = healthChecker;
    }

    public void memberAdded(Member member, boolean b) {
        log.info((Object)("ELB Member [" + member + "] joined cluster"));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    RegistrantUtil.reloadRegistrants(ELBMembershipListener.this.clusteringClient, ELBMembershipListener.this.configurationContext, ELBMembershipListener.this.registrantDatabase);
                    ELBMembershipListener.this.healthChecker.setELBRunning(true);
                }
                catch (CartridgeAgentException e) {
                    log.error((Object)"Could not reload registrants", (Throwable)e);
                }
            }
        };
        new Thread(runnable).start();
    }

    public void memberDisappeared(Member member, boolean b) {
        log.info((Object)("ELB Member [" + member + "] left cluster"));
        this.healthChecker.setELBRunning(false);
        this.registrantDatabase.stopAll();
    }
}

