/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.utils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.NoSuchEntityException;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.stanbol.commons.jobs.api.Job;
import org.apache.stanbol.commons.owl.transformation.JenaToClerezzaConverter;
import org.apache.stanbol.commons.owl.transformation.OWLAPIToClerezzaConverter;
import org.apache.stanbol.reasoners.jena.JenaReasoningService;
import org.apache.stanbol.reasoners.owlapi.OWLApiReasoningService;
import org.apache.stanbol.reasoners.servicesapi.InconsistentInputException;
import org.apache.stanbol.reasoners.servicesapi.ReasoningService;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceException;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputManager;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputProvider;
import org.apache.stanbol.reasoners.servicesapi.UnsupportedTaskException;
import org.apache.stanbol.reasoners.web.utils.ReasoningServiceResult;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SWRLRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReasoningServiceExecutor
implements Job {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private TcManager tcManager;
    private ReasoningServiceInputManager inmgr;
    private ReasoningService<?, ?, ?> service;
    private String task;
    private Map<String, List<String>> parameters;
    private String targetGraph;
    public static String TASK_CHECK = "check";

    public ReasoningServiceExecutor(TcManager tcManager, ReasoningServiceInputManager inmgr, ReasoningService<?, ?, ?> service, String task, String targetGraph, Map<String, List<String>> parameters) {
        this.tcManager = tcManager;
        this.inmgr = inmgr;
        this.service = service;
        this.task = task;
        this.targetGraph = targetGraph;
        this.parameters = parameters;
    }

    private ReasoningServiceResult<Model> executeJenaReasoningService(String task, JenaReasoningService s, Model input, List<Rule> rules, String targetGraphID, boolean filtered, Map<String, List<String>> parameters) throws ReasoningServiceException, UnsupportedTaskException {
        if (task.equals(TASK_CHECK)) {
            this.log.debug("Task is '{}'", (Object)TASK_CHECK);
            try {
                boolean is = s.isConsistent((Object)input);
                return new ReasoningServiceResult<Model>(TASK_CHECK, is);
            }
            catch (ReasoningServiceException e) {
                this.log.error("Error thrown: {}", (Throwable)e);
                throw e;
            }
        }
        try {
            Set result = s.runTask(task, (Object)input, rules, filtered, parameters);
            if (result == null) {
                this.log.error("Result is null");
                throw new RuntimeException("Result is null.");
            }
            Model outputModel = ModelFactory.createDefaultModel();
            outputModel.add(result.toArray(new Statement[result.size()]));
            this.log.debug("Prepare output");
            if (targetGraphID == null) {
                this.log.debug("Returning {} statements", (Object)result.size());
                return new ReasoningServiceResult<Model>(task, true, outputModel);
            }
            this.save(outputModel, targetGraphID);
            return new ReasoningServiceResult<Model>(task, true);
        }
        catch (ReasoningServiceException e) {
            this.log.error("Error thrown: {}", (Throwable)e);
            throw e;
        }
        catch (InconsistentInputException e) {
            this.log.debug("The input is not consistent");
            return new ReasoningServiceResult<Model>(TASK_CHECK, false);
        }
        catch (UnsupportedTaskException e) {
            this.log.error("Error thrown: {}", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            throw new ReasoningServiceException((Throwable)e);
        }
    }

    private ReasoningServiceResult<OWLOntology> executeOWLApiReasoningService(String task, OWLApiReasoningService s, OWLOntology input, List<SWRLRule> rules, String targetGraphID, boolean filtered, Map<String, List<String>> parameters) throws InconsistentInputException, ReasoningServiceException, UnsupportedTaskException {
        if (task.equals(TASK_CHECK)) {
            this.log.debug("Task is '{}'", (Object)TASK_CHECK);
            boolean is = s.isConsistent((Object)input);
            return new ReasoningServiceResult<OWLOntology>(TASK_CHECK, is);
        }
        OWLOntologyManager manager = input.getOWLOntologyManager();
        try {
            OWLOntology output = manager.createOntology();
            Set axioms = s.runTask(task, (Object)input, rules, filtered, parameters);
            this.log.debug("Prepare output: {} axioms", (Object)axioms.size());
            manager.addAxioms(output, axioms);
            if (targetGraphID == null) {
                return new ReasoningServiceResult<OWLOntology>(task, true, manager.getOntology(output.getOntologyID()));
            }
            this.save(output, targetGraphID);
            return new ReasoningServiceResult<OWLOntology>(task, true);
        }
        catch (InconsistentInputException e) {
            this.log.warn("The input is not consistent");
            return new ReasoningServiceResult<OWLOntology>(TASK_CHECK, false);
        }
        catch (ReasoningServiceException e) {
            throw e;
        }
        catch (OWLOntologyCreationException e) {
            this.log.error("Error! \n", (Throwable)e);
            throw new ReasoningServiceException((Throwable)new IOException(e));
        }
        catch (UnsupportedTaskException e) {
            this.log.error("Error! \n", (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            this.log.error("Error! \n", t);
            throw new ReasoningServiceException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(Object data, String targetGraphID) throws IOException {
        MGraph m;
        LockableMGraph mGraph;
        this.log.debug("Attempt saving in target graph {}", (Object)targetGraphID);
        long startSave = System.currentTimeMillis();
        UriRef graphUriRef = new UriRef(targetGraphID);
        TcManager tcManager = this.tcManager;
        synchronized (tcManager) {
            try {
                mGraph = this.tcManager.getMGraph(graphUriRef);
            }
            catch (NoSuchEntityException e) {
                mGraph = this.tcManager.createMGraph(graphUriRef);
            }
        }
        Lock writeLock = mGraph.getLock().writeLock();
        boolean saved = false;
        if (data instanceof Model) {
            m = JenaToClerezzaConverter.jenaModelToClerezzaMGraph((Model)((Model)data));
            writeLock.lock();
            saved = mGraph.addAll((Collection)m);
            writeLock.unlock();
        } else if (data instanceof OWLOntology) {
            m = (MGraph)OWLAPIToClerezzaConverter.owlOntologyToClerezzaMGraph((OWLOntology)((OWLOntology)data));
            writeLock.lock();
            saved = mGraph.addAll((Collection)m);
            writeLock.unlock();
        }
        if (!saved) {
            throw new IOException("Cannot save the result in clerezza!");
        }
        long endSave = System.currentTimeMillis();
        this.log.debug("Saved in time: {}ms", (Object)(endSave - startSave));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReasoningServiceResult<?> execute(String task, ReasoningService<?, ?, ?> service, String targetGraphID, Map<String, List<String>> parameters) throws ReasoningServiceException, UnsupportedTaskException, InconsistentInputException {
        ArrayList<Object> rules;
        Iterator statements;
        Model input;
        long start = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.log.debug("[start] Execution: {}", (Object)service.getClass().getCanonicalName());
            this.log.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.log.debug("-----------------------------------------------------");
            this.log.debug("execute()");
            this.log.debug(" > task: {}", (Object)task);
            this.log.debug(" > service: {}", (Object)service.getClass().getCanonicalName());
            this.log.debug(" > target: {}", (Object)targetGraphID);
            this.log.debug(" > parameters:");
            for (Map.Entry<String, List<String>> e : parameters.entrySet()) {
                this.log.debug(" >> {}: {}", (Object)e.getKey());
                for (String v : e.getValue()) {
                    this.log.debug(" >>> value: {}", (Object)v);
                }
            }
            this.log.debug(" > input providers:");
            for (ReasoningServiceInputProvider p : this.inmgr.getProviders()) {
                this.log.debug(" >> {}", (Object)p.getClass().getCanonicalName());
            }
            this.log.debug("-----------------------------------------------------");
        }
        ReasoningServiceResult<Model> result = null;
        if (service instanceof JenaReasoningService) {
            input = ModelFactory.createDefaultModel();
            ReasoningServiceInputManager i$ = this.inmgr;
            synchronized (i$) {
                statements = this.inmgr.getInputData(Statement.class);
                while (statements.hasNext()) {
                    input.add((Statement)statements.next());
                }
            }
            rules = null;
            statements = this.inmgr;
            synchronized (statements) {
                Iterator rulesI = this.inmgr.getInputData(Rule.class);
                while (rulesI.hasNext()) {
                    Rule o = (Rule)rulesI.next();
                    this.log.debug("Rule: {}", (Object)o);
                    if (rules == null) {
                        rules = new ArrayList<Rule>();
                    }
                    rules.add(o);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Input size is {} statements", (Object)input.listStatements().toSet().size());
            }
            result = this.executeJenaReasoningService(task, (JenaReasoningService)service, input, rules, targetGraphID, true, parameters);
        } else if (service instanceof OWLApiReasoningService) {
            try {
                input = OWLManager.createOWLOntologyManager().createOntology();
            }
            catch (OWLOntologyCreationException e) {
                throw new ReasoningServiceException((Throwable)e);
            }
            ReasoningServiceInputManager e = this.inmgr;
            synchronized (e) {
                statements = this.inmgr.getInputData(OWLAxiom.class);
                while (statements.hasNext()) {
                    input.getOWLOntologyManager().addAxiom((OWLOntology)input, (OWLAxiom)statements.next());
                }
            }
            input = input.getOWLOntologyManager().getOntology(input.getOntologyID());
            rules = null;
            ReasoningServiceInputManager reasoningServiceInputManager = this.inmgr;
            synchronized (reasoningServiceInputManager) {
                Iterator rulesI = this.inmgr.getInputData(SWRLRule.class);
                while (rulesI.hasNext()) {
                    if (rules == null) {
                        rules = new ArrayList();
                    }
                    rules.add((Rule)rulesI.next());
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Input size is {} statements", (Object)input.getAxiomCount());
            }
            result = this.executeOWLApiReasoningService(task, (OWLApiReasoningService)service, (OWLOntology)input, rules, targetGraphID, true, parameters);
        } else {
            throw new UnsupportedOperationException("Service implementation not supported!");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            long end = System.currentTimeMillis();
            this.log.debug("[end] In time: {}ms", (Object)(end - start));
            this.log.debug("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        }
        return result;
    }

    public ReasoningServiceResult<?> call() throws Exception {
        return this.execute(this.task, this.service, this.targetGraph, this.parameters);
    }

    public String buildResultLocation(String jobId) {
        return "reasoners/jobs/" + jobId;
    }
}

