/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.resources;

import com.sun.jersey.api.view.Viewable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.stanbol.commons.jobs.api.JobManager;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.reasoners.web.utils.ReasoningServiceResult;
import org.apache.stanbol.reasoners.web.utils.ResponseTaskBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/reasoners/jobs")
public class JobsResource
extends BaseStanbolResource {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServletContext context;
    private HttpHeaders headers;
    private String jobLocation = "";

    public JobsResource(@Context ServletContext servletContext, @Context HttpHeaders headers) {
        this.context = servletContext;
        this.headers = headers;
    }

    @GET
    @Path(value="/{jid}")
    public Response get(@PathParam(value="jid") String id, @Context HttpHeaders headers) {
        this.log.info("Pinging job {}", (Object)id);
        if (id == null || id.equals("")) {
            Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        JobManager m = this.getJobManager();
        if (m.hasJob(id)) {
            String jobService;
            this.log.info("Found job with id {}", (Object)id);
            Future f = m.ping(id);
            if (f.isDone() && !f.isCancelled()) {
                try {
                    Object o = f.get();
                    if (o instanceof ReasoningServiceResult) {
                        this.log.debug("Is a ReasoningServiceResult");
                        ReasoningServiceResult result = (ReasoningServiceResult)o;
                        return new ResponseTaskBuilder(this.uriInfo, this.context, headers).build(result);
                    }
                    this.log.error("Job {} does not belong to reasoners", (Object)id);
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                catch (InterruptedException e) {
                    this.log.error("Error: ", (Throwable)e);
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (ExecutionException e) {
                    this.log.error("Error: ", (Throwable)e);
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            this.jobLocation = jobService = this.getPublicBaseUri() + "jobs/" + id;
            Viewable viewable = new Viewable("404.ftl", (Object)this);
            Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.NOT_FOUND);
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            rb.entity((Object)viewable);
            return rb.build();
        }
        this.log.info("No job found with id {}", (Object)id);
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.NOT_FOUND);
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    public String getJobLocation() {
        return this.jobLocation;
    }

    private JobManager getJobManager() {
        this.log.debug("(getJobManager()) ");
        return (JobManager)ContextHelper.getServiceFromContext(JobManager.class, (ServletContext)this.context);
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers, (String[])new String[0]);
        return rb.build();
    }
}

