/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.input.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.stanbol.ontologymanager.ontonet.api.ONManager;
import org.apache.stanbol.ontologymanager.ontonet.api.session.SessionManager;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputFactory;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputManager;
import org.apache.stanbol.reasoners.web.input.impl.SimpleInputManager;
import org.apache.stanbol.reasoners.web.input.provider.impl.FileInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.OntonetInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.RecipeInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.UrlInputProvider;
import org.apache.stanbol.rules.base.api.RuleStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTInputFactory
implements ReasoningServiceInputFactory {
    ONManager onm;
    SessionManager sessionManager;
    RuleStore rStore;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public RESTInputFactory(ONManager onm, SessionManager sm, RuleStore rStore) {
        this.onm = onm;
        this.sessionManager = sm;
        this.rStore = rStore;
    }

    public ReasoningServiceInputManager createInputManager(Map<String, List<String>> parameters) {
        SimpleInputManager inmgr = new SimpleInputManager();
        String scope = null;
        String session = null;
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            if (entry.getKey().equals("url")) {
                if (!entry.getValue().isEmpty()) {
                    inmgr.addInputProvider(new UrlInputProvider(entry.getValue().iterator().next()));
                    continue;
                }
                this.log.error("Parameter 'url' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (entry.getKey().equals("file")) {
                if (!entry.getValue().isEmpty()) {
                    inmgr.addInputProvider(new FileInputProvider(new File(entry.getValue().iterator().next())));
                    continue;
                }
                this.log.error("Parameter 'url' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (entry.getKey().equals("scope")) {
                if (!entry.getValue().isEmpty()) {
                    scope = entry.getValue().iterator().next();
                    continue;
                }
                this.log.error("Parameter 'scope' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (entry.getKey().equals("session")) {
                if (!entry.getValue().isEmpty()) {
                    session = entry.getValue().iterator().next();
                    continue;
                }
                this.log.error("Parameter 'session' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (!entry.getKey().equals("recipe")) continue;
            if (!entry.getValue().isEmpty()) {
                inmgr.addInputProvider(new RecipeInputProvider(this.rStore, entry.getValue().iterator().next()));
                continue;
            }
            this.log.error("Parameter 'recipe' must have a value!");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (scope != null) {
            inmgr.addInputProvider(new OntonetInputProvider(this.onm, this.sessionManager, scope, session));
        }
        return inmgr;
    }
}

