/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.query;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;

public class ValueConstraint
extends Constraint {
    private final Object value;
    private final Collection<String> dataTypeUris;

    public ValueConstraint(Object value) {
        this(value, null);
    }

    public ValueConstraint(Object value, Iterable<String> dataTypes) {
        super(Constraint.ConstraintType.value);
        this.value = value;
        this.dataTypeUris = new LinkedHashSet<String>();
        if (dataTypes != null) {
            for (String dataType : dataTypes) {
                if (dataType == null || dataType.isEmpty()) continue;
                this.dataTypeUris.add(dataType);
            }
        }
        if (value == null && this.dataTypeUris.isEmpty()) {
            throw new IllegalArgumentException("A value constraint MUST define at least a value or a valid - NOT NULL, NOT empty - data type uri!");
        }
    }

    public final Object getValue() {
        return this.value;
    }

    public final Collection<String> getDataTypes() {
        return this.dataTypeUris;
    }

    public String toString() {
        return String.format("ValueConstraint[value=%s|types:%s]", this.value, this.dataTypeUris);
    }
}

