/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.defaults;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NamespaceEnum {
    entityhubModel("entityhub", "http://www.iks-project.eu/ontology/rick/model/"),
    entityhubQuery("entityhub-query", "http://www.iks-project.eu/ontology/rick/query/"),
    xsd("http://www.w3.org/2001/XMLSchema#"),
    xsi("http://www.w3.org/2001/XMLSchema-instance#"),
    xml("http://www.w3.org/XML/1998/namespace#"),
    rdf("http://www.w3.org/1999/02/22-rdf-syntax-ns#"),
    rdfs("http://www.w3.org/2000/01/rdf-schema#"),
    owl("http://www.w3.org/2002/07/owl#"),
    atom("http://www.w3.org/2005/Atom"),
    cmis("http://docs.oasis-open.org/ns/cmis/core/200908/"),
    cmisRa("cmis-ra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/"),
    jcr("jcr", "http://www.jcp.org/jcr/1.0/"),
    jcrSv("jcr-sv", "http://www.jcp.org/jcr/sv/1.0/"),
    jcrNt("jcr-nt", "http://www.jcp.org/jcr/nt/1.0/"),
    jcrMix("jcr-mix", "http://www.jcp.org/jcr/mix/1.0/"),
    geo("http://www.w3.org/2003/01/geo/wgs84_pos#"),
    georss("http://www.georss.org/georss/"),
    gml("http://www.opengis.net/gml/"),
    dcElements("dc-elements", "http://purl.org/dc/elements/1.1/"),
    dcTerms("dc", "http://purl.org/dc/terms/"),
    foaf("http://xmlns.com/foaf/0.1/"),
    vCal("http://www.w3.org/2002/12/cal#"),
    vCard("http://www.w3.org/2001/vcard-rdf/3.0#"),
    skos("http://www.w3.org/2004/02/skos/core#"),
    sioc("http://rdfs.org/sioc/ns#"),
    siocTypes("sioc-types", "http://rdfs.org/sioc/types#"),
    bio("dc-bio", "http://purl.org/vocab/bio/0.1/"),
    rss("http://purl.org/rss/1.0/"),
    goodRelations("gr", "http://purl.org/goodrelations/v1#"),
    swrc("http://swrc.ontoware.org/ontology#"),
    dbpediaOnt("dbp-ont", "http://dbpedia.org/ontology/"),
    dbpediaProp("dbp-prop", "http://dbpedia.org/property/"),
    geonames("http://www.geonames.org/ontology#"),
    cc("http://creativecommons.org/ns#"),
    schema("http://schema.org/", true),
    media("http://www.w3.org/ns/ma-ont#"),
    drugbank("http://www4.wiwiss.fu-berlin.de/drugbank/resource/drugbank/"),
    dailymed("http://www4.wiwiss.fu-berlin.de/dailymed/resource/dailymed/"),
    sider("http://www4.wiwiss.fu-berlin.de/sider/resource/sider/"),
    linkedct("http://data.linkedct.org/resource/linkedct/"),
    stitch("http://www4.wiwiss.fu-berlin.de/stitch/resource/stitch/"),
    diseasome("http://www4.wiwiss.fu-berlin.de/diseasome/resource/diseasome/"),
    nci("http://www.mindswap.org/2003/nciOncology.owl#"),
    tcm("http://purl.org/net/tcm/tcm.lifescience.ntu.edu.tw/");

    private static final Logger log;
    private final String ns;
    private final String prefix;
    private final boolean defaultPrefix;
    private static final Map<String, NamespaceEnum> prefix2Namespace;
    private static final Map<String, NamespaceEnum> namespace2Prefix;
    private static final NamespaceEnum defaultNamespace;

    private NamespaceEnum(String ns) {
        this(null, ns, false);
    }

    private NamespaceEnum(String ns, boolean defaultPrefix) {
        this(null, ns, defaultPrefix);
    }

    private NamespaceEnum(String prefix, String ns) {
        this(prefix, ns, false);
    }

    private NamespaceEnum(String prefix, String ns, boolean defaultPrefix) {
        if (ns == null || ns.isEmpty()) {
            throw new IllegalArgumentException("The namespace MUST NOT be NULL nor empty");
        }
        this.ns = ns;
        if (prefix == null) {
            this.prefix = this.name();
        } else {
            if (prefix.isEmpty()) {
                throw new IllegalArgumentException("The prefix MUST NOT be emtpty.Use NULL to use the name or parse the prefix to use");
            }
            this.prefix = prefix;
        }
        this.defaultPrefix = defaultPrefix;
    }

    public String getNamespace() {
        return this.ns;
    }

    public String getPrefix() {
        return this.prefix == null ? this.name() : this.prefix;
    }

    public String toString() {
        return this.ns;
    }

    public static NamespaceEnum forNamespace(String namespace) {
        return namespace2Prefix.get(namespace);
    }

    public static NamespaceEnum forPrefix(String prefix) {
        return prefix == null ? defaultNamespace : prefix2Namespace.get(prefix);
    }

    public static String getFullName(String shortUri) {
        if (shortUri == null) {
            return null;
        }
        int index = shortUri.indexOf(58);
        if (index > 0) {
            NamespaceEnum namespace = NamespaceEnum.forPrefix(shortUri.substring(0, index));
            if (namespace != null) {
                shortUri = namespace.getNamespace() + shortUri.substring(index + 1);
            }
        } else if (defaultNamespace != null) {
            shortUri = defaultNamespace.getNamespace() + shortUri;
        }
        return shortUri;
    }

    public static String getShortName(String fullUri) {
        String ns;
        NamespaceEnum namespace;
        if (fullUri == null) {
            return fullUri;
        }
        int index = Math.max(fullUri.lastIndexOf(35), fullUri.lastIndexOf(47));
        if (index > 0 && index + 1 < fullUri.length() && (namespace = namespace2Prefix.get(ns = fullUri.substring(0, index + 1))) != null) {
            return namespace.getPrefix() + ':' + fullUri.substring(index + 1);
        }
        return fullUri;
    }

    public boolean isDefault() {
        return this.defaultPrefix;
    }

    static {
        log = LoggerFactory.getLogger(NamespaceEnum.class);
        HashMap<String, NamespaceEnum> p2n = new HashMap<String, NamespaceEnum>();
        HashMap<String, NamespaceEnum> n2p = new HashMap<String, NamespaceEnum>();
        NamespaceEnum defaultNs = null;
        for (NamespaceEnum entry : NamespaceEnum.values()) {
            if (entry.isDefault()) {
                if (defaultNs == null) {
                    defaultNs = entry;
                } else {
                    log.warn("Found multiple default namespace definitions! Will use the one with the lowest ordinal value.");
                    log.warn(" > used default: prefix:{}, namespace:{}, ordinal:{}", new Object[]{defaultNs.getPrefix(), defaultNs.getNamespace(), defaultNs.ordinal()});
                    log.warn(" > this one    : prefix:{}, namespace:{}, ordinal:{}", new Object[]{entry.getPrefix(), entry.getNamespace(), entry.ordinal()});
                }
            }
            if (p2n.containsKey(entry.getPrefix())) {
                throw new IllegalStateException(String.format("Prefix %s used for multiple namespaces: %s and %s", entry.getPrefix(), p2n.get(entry.getPrefix()), entry.getNamespace()));
            }
            log.debug("add {} -> {} mapping", (Object)entry.getPrefix(), (Object)entry.getNamespace());
            p2n.put(entry.getPrefix(), entry);
            if (n2p.containsKey(entry.getNamespace())) {
                throw new IllegalStateException(String.format("Multiple Prefixs %s and %s for namespaces: %s", entry.getPrefix(), p2n.get(entry.getNamespace()), entry.getNamespace()));
            }
            log.debug("add {} -> {} mapping", (Object)entry.getNamespace(), (Object)entry.getPrefix());
            n2p.put(entry.getNamespace(), entry);
        }
        prefix2Namespace = Collections.unmodifiableMap(p2n);
        namespace2Prefix = Collections.unmodifiableMap(n2p);
        defaultNamespace = defaultNs;
    }
}

