/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class AdaptingIterator<T, A>
implements Iterator<A> {
    private final Adapter<T, A> adapter;
    private final Iterator<T> it;
    private final Class<A> type;
    private A next;
    private Boolean hasNext;

    public AdaptingIterator(Iterator<T> it, Adapter<T, A> adapter, Class<A> type) {
        if (it == null) {
            throw new IllegalArgumentException("Parsed iterator MUST NOT be NULL!");
        }
        if (adapter == null) {
            throw new IllegalArgumentException("Parsed adapter MUST NOT be NULL!");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parsed type MUST NOT be NULL!");
        }
        this.it = it;
        this.adapter = adapter;
        this.type = type;
    }

    @Override
    public final boolean hasNext() {
        if (this.hasNext == null) {
            this.next = this.prepareNext();
            this.hasNext = this.next != null;
        }
        return this.hasNext;
    }

    @Override
    public final A next() {
        this.hasNext();
        if (!this.hasNext.booleanValue()) {
            throw new NoSuchElementException();
        }
        A current = this.next;
        this.next = null;
        this.hasNext = null;
        return current;
    }

    @Override
    public final void remove() {
        if (this.hasNext != null) {
            throw new IllegalStateException("Remove can not be called after calling hasNext()! See java doc for more information.");
        }
        this.it.remove();
    }

    protected A prepareNext() {
        while (this.it.hasNext()) {
            T check = this.it.next();
            A converted = this.adapter.adapt(check, this.type);
            if (converted == null) continue;
            return converted;
        }
        return null;
    }

    public static interface Adapter<T, A> {
        public A adapt(T var1, Class<A> var2);
    }
}

