/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;

public class TextConstraint
extends Constraint {
    private final PatternType wildcardType;
    private final Set<String> languages;
    private final boolean caseSensitive;
    private final List<String> texts;
    private boolean proximityRanking;

    public TextConstraint(List<String> text, String ... languages) {
        this(text, PatternType.none, false, languages);
    }

    public TextConstraint(String text, String ... languages) {
        this(text == null || text.isEmpty() ? null : Collections.singletonList(text), PatternType.none, false, languages);
    }

    public TextConstraint(List<String> text, boolean caseSensitive, String ... languages) {
        this(text, PatternType.none, caseSensitive, languages);
    }

    public TextConstraint(String text, boolean caseSensitive, String ... languages) {
        this(text == null || text.isEmpty() ? null : Collections.singletonList(text), PatternType.none, caseSensitive, languages);
    }

    public TextConstraint(String text, PatternType wildcardType, boolean caseSensitive, String ... languages) {
        this(text == null || text.isEmpty() ? null : Collections.singletonList(text), wildcardType, caseSensitive, languages);
    }

    public TextConstraint(List<String> text, PatternType wildcardType, boolean caseSensitive, String ... languages) {
        super(Constraint.ConstraintType.text);
        if (text == null || text.isEmpty()) {
            this.texts = null;
        } else {
            ArrayList<String> processedText = new ArrayList<String>(text);
            Iterator constraints = processedText.iterator();
            while (constraints.hasNext()) {
                String constraint = (String)constraints.next();
                if (constraint != null && !constraint.isEmpty()) continue;
                constraints.remove();
            }
            this.texts = processedText.isEmpty() ? null : Collections.unmodifiableList(processedText);
        }
        if (this.texts == null && (languages == null || languages.length < 1)) {
            throw new IllegalArgumentException("Text Constraint MUST define a non empty text OR a non empty list of language constraints");
        }
        this.wildcardType = wildcardType == null ? PatternType.none : wildcardType;
        this.languages = languages == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(languages)));
        this.caseSensitive = caseSensitive;
    }

    public final PatternType getPatternType() {
        return this.wildcardType;
    }

    public final Set<String> getLanguages() {
        return this.languages;
    }

    public final boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public final List<String> getTexts() {
        return this.texts;
    }

    @Deprecated
    public final String getText() {
        return this.texts == null || this.texts.isEmpty() ? null : this.texts.get(0);
    }

    public Boolean isProximityRanking() {
        return this.proximityRanking;
    }

    public void setProximityRanking(boolean state) {
        this.proximityRanking = state;
    }

    @Override
    public String toString() {
        return String.format("TextConstraint[value=%s|%s|case %sensitive|languages:%s]", this.texts, this.wildcardType.name(), this.caseSensitive ? "" : "in", this.languages);
    }

    public static enum PatternType {
        none,
        regex,
        wildcard;

    }
}

