/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.model.rdf;

import org.apache.stanbol.entityhub.servicesapi.defaults.NamespaceEnum;

public enum RdfResourceEnum {
    Representation,
    Entity,
    site,
    entityRank,
    Metadata(NamespaceEnum.foaf, "Document"),
    aboutRepresentation(null, "about"),
    label,
    description,
    predecessor,
    successor,
    hasState,
    EntityState,
    entityStateActive(null, "entityState-active"),
    entityStateDepreciated(null, "entityState-depreciated"),
    entityStateProposed(null, "entityState-proposed"),
    entityStateRemoved(null, "entityState-removed"),
    mappedTo,
    EntityMapping,
    mappingSource,
    mappingTarget,
    hasMappingState,
    expires,
    MappingState,
    mappingStateConfirmed(null, "mappingState-confirmed"),
    mappingStateExpired(null, "mappingState-expired"),
    mappingStateProposed(null, "mappingState-proposed"),
    mappingStateRejected(null, "mappingState-rejected"),
    QueryResultSet(NamespaceEnum.entityhubQuery),
    queryResult(NamespaceEnum.entityhubQuery),
    query(NamespaceEnum.entityhubQuery),
    resultScore(NamespaceEnum.entityhubQuery, "score"),
    resultSite(NamespaceEnum.entityhubQuery),
    ReferenceDataType(null, "ref"),
    TextDataType(null, "text"),
    isChached;

    private String uri;

    private RdfResourceEnum(String uri) {
        if (uri == null) {
            this.uri = (Object)((Object)NamespaceEnum.entityhub) + this.name();
        }
        this.uri = uri;
    }

    private RdfResourceEnum(NamespaceEnum ns) {
        this(ns, null);
    }

    private RdfResourceEnum(NamespaceEnum ns, String localName) {
        String uri = ns == null ? NamespaceEnum.entityhub.getNamespace() : ns.getNamespace();
        uri = localName == null ? uri + this.name() : uri + localName;
        this.uri = uri;
    }

    private RdfResourceEnum() {
        this(null, null);
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return this.uri;
    }
}

