/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.stanbol.entityhub.servicesapi.model.Text;
import org.apache.stanbol.entityhub.servicesapi.model.ValueFactory;
import org.apache.stanbol.entityhub.servicesapi.util.AdaptingIterator;

public class TextIterator
extends AdaptingIterator<Object, Text>
implements Iterator<Text> {
    public TextIterator(ValueFactory valueFactory, Iterator<Object> it, String ... languages) {
        super(it, new TextAdapter(valueFactory, languages), Text.class);
    }

    private static class TextAdapter
    implements AdaptingIterator.Adapter<Object, Text> {
        private final Set<String> languages;
        private final boolean isNullLanguage;
        private final ValueFactory valueFactory;

        public TextAdapter(ValueFactory valueFactory, String ... languages) {
            if (valueFactory == null) {
                throw new IllegalArgumentException("Parsed ValueFactory MUST NOT be NULL!");
            }
            this.valueFactory = valueFactory;
            if (languages != null && languages.length > 0) {
                this.languages = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(languages)));
                this.isNullLanguage = this.languages.contains(null);
            } else {
                this.languages = null;
                this.isNullLanguage = true;
            }
        }

        @Override
        public Text adapt(Object value, Class<Text> type) {
            if (value instanceof Text) {
                Text text = (Text)value;
                if (this.languages == null || this.languages.contains(text.getLanguage())) {
                    return text;
                }
                return null;
            }
            if (this.isNullLanguage && value instanceof String) {
                return this.valueFactory.createText((String)value);
            }
            return null;
        }
    }
}

