/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.stanbol.entityhub.servicesapi.defaults.DataTypeEnum;
import org.apache.stanbol.entityhub.servicesapi.query.ValueConstraint;

public class ReferenceConstraint
extends ValueConstraint {
    private Set<String> references;

    public ReferenceConstraint(String reference) {
        this(reference != null ? Collections.singleton(reference) : null);
    }

    public ReferenceConstraint(Collection<String> references) {
        this(references, null);
    }

    public ReferenceConstraint(Collection<String> references, ValueConstraint.MODE mode) {
        super(references, Arrays.asList(DataTypeEnum.Reference.getUri()), mode);
        if (references == null) {
            throw new IllegalArgumentException("Parsed Reference(s) MUST NOT be NULL");
        }
        LinkedHashSet<String> r = new LinkedHashSet<String>(this.getValues().size());
        for (Object value : this.getValues()) {
            r.add((String)value);
        }
        this.references = Collections.unmodifiableSet(r);
    }

    public Set<String> getReferences() {
        return this.references;
    }
}

